
#include "environnement.h"

//***************************************************************************
//						class contour : le tour de l'image
//constructeur
SDL_Surface* contour::textureD=SDL_LoadBMP( "coteD.bmp" );
SDL_Surface* contour::textureB=SDL_LoadBMP( "coteB.bmp" );
contour::contour(SDL_Surface* fond){
	coordonnee c;
	SDL_Surface *cot=IMG_Load("coteG.bmp");
	SDL_SetColorKey(cot,SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
	SDL_Rect dest={DEPLACEMENT_X-15,DEPLACEMENT_Y-20,0,0};
	SDL_BlitSurface(cot,NULL,fond,&dest);
	cot=IMG_Load("coteH.bmp");
	SDL_SetColorKey(cot,SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
	dest.x=DEPLACEMENT_X;
	dest.y=DEPLACEMENT_Y-20;
	SDL_BlitSurface(cot,NULL,fond,&dest);
	SDL_SetColorKey(textureD,SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
	rectD.x=NB_CASE_X*50+DEPLACEMENT_X;
	rectD.y=DEPLACEMENT_Y-20;
	rectD.w=27;
	rectD.h=NB_CASE_Y*50+27+DEPLACEMENT_Y-20;
	SDL_BlitSurface(textureD,NULL,fond,&rectD);
	SDL_SetColorKey(textureB,SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
	rectB.x=DEPLACEMENT_X-15;
	rectB.y=NB_CASE_Y*50+20;
	rectB.w=NB_CASE_X*50+42;
	rectB.h=30;
	SDL_BlitSurface(textureB,NULL,fond,&rectB);
};


int contour::print(SDL_Surface *Background,SDL_Rect &rect){
	SDL_Rect tmp;
	SDL_Rect dest;
	if(rect.x>500){
		tmp=rect;
		dest=rectD;
		tmp.x=rect.x-rectD.x;
		tmp.y=rect.y-rectD.y;
		dest.x=rect.x;
		dest.y=rect.y;
		SDL_BlitSurface(textureD,&tmp,Background,&dest);
	};
	if(rect.y>500){
		tmp=rect;
		dest=rectB;
		tmp.x=rect.x-rectB.x;
		tmp.y=rect.y-rectB.y;
		dest.x=rect.x;
		dest.y=rect.y;
		SDL_BlitSurface(textureB,&tmp,Background,&dest);
	};
	return 0;
};


//***************************************************************************************
//**
Execution::Execution(int x,int y){
	larg=x;
	haut=y;
	full=false;
	if ( SDL_Init( SDL_INIT_VIDEO|SDL_INIT_TIMER  ) == -1 ) 
	{
		printf( "Echec lors de l'initialisation de la vido : SDL.dll manquant!!!");
		exit(1);
	}else{
		atexit(SDL_Quit);
		/* Initialisation du mode vido le plus adapt  la carte vido */
		surface = SDL_SetVideoMode(x,y,32, SDL_HWSURFACE| SDL_DOUBLEBUF);//|SDL_FULLSCREEN
		if ( surface == NULL ) {
			printf("Impossible d'initialiser le mode %dx%dx32 : %s\n",x,y,SDL_GetError());
			exit(1);
		};
	};
	SDL_EnableUNICODE(1);
	SDL_ShowCursor(false);
	if (!FSOUND_Init(44100,4,0)){
		printf("init ratee...\n%s\n",FSOUND_GetError());
		exit(5);
	};
	bombe::init();
	brique::init();
	feu::init();
	debug::init();

};


void Execution::actualise(int& temps,SDL_Event& event){
	int heure_actuelle;
	if (temps==0){
		coordonnee c;
		SDL_Surface *buffer= SDL_CreateRGBSurface(SDL_HWSURFACE, larg,haut, 32,
			0, 0, 0, 0);
		if(buffer == NULL) {
			fprintf(stderr, "CreateRGBSurface non abouti: %s\n", SDL_GetError());
			exit(1);
		};
		joueur *j[4];
		c.init((NB_CASE_X)*50-30,-20);
		j[0]=new trash(c,surface,0);
		c.init(10,(NB_CASE_Y-1)*50-20);
		j[1]=new merlin(c,surface,1);
		c.init((NB_CASE_X-1)*50-30,(NB_CASE_Y-1)*50-20);
		j[2]=new trash(c,surface,2,true);
		c.init(10,-20);
		j[3]=new merlin(c,surface,3,true);
		bomber.cree1(surface,j);//cree l'environnement
		SDL_BlitSurface(surface,NULL,buffer,NULL);
		SDL_Flip(surface);
		SDL_BlitSurface(buffer,NULL,surface,NULL);
		SDL_FreeSurface(buffer);
	}else{
		bomber.actualise(event,surface);
		if (bomber.pe()){
			SDL_Surface *buffer= SDL_CreateRGBSurface(SDL_HWSURFACE, larg,haut, 32,
				0, 0, 0, 0);
			if(buffer == NULL) {
				fprintf(stderr, "CreateRGBSurface non abouti: %s\n", SDL_GetError());
				exit(1);
			};
			SDL_BlitSurface(surface,NULL,buffer,NULL);
			if (full){
				SDL_FreeSurface(surface);surface=NULL;
				surface = SDL_SetVideoMode(800,600,32, SDL_HWSURFACE| SDL_DOUBLEBUF);
				if ( surface == NULL ) {
					printf("Impossible d'initialiser le plein ecran %dx%dx32\n");
					exit(1);
				};
				full=false;
				SDL_BlitSurface(buffer,NULL,surface,NULL);
				SDL_Flip(surface);
				SDL_BlitSurface(buffer,NULL,surface,NULL);
			}else{
				SDL_FreeSurface(surface);surface=NULL;
				surface = SDL_SetVideoMode(800,600,32, SDL_HWSURFACE| SDL_DOUBLEBUF|SDL_FULLSCREEN);
				if ( surface == NULL ) {
					printf("Impossible d'initialiser le plein ecran %dx%dx32\n");
					exit(1);
				};
				full=true;
				SDL_BlitSurface(buffer,NULL,surface,NULL);
				SDL_Flip(surface);
				SDL_BlitSurface(buffer,NULL,surface,NULL);
			};
			SDL_FreeSurface(buffer);
		};
	};
	heure_actuelle = SDL_GetTicks()+3;
	if((heure_actuelle<temps)&&(DEBUG==0))
		SDL_Delay(temps-heure_actuelle);
	/* On fixe la date du prochain changement*/
	temps = heure_actuelle + 30;
	SDL_Flip(surface);
};


//***************************************************************************
//classe de chainage des objets : class liste (utilise le tableau declare dans coordonnee
int liste::actux=0;
int liste::actuy=0;
bool liste::ajout(objet *o){
	int x=o->getCaseX();
	int y=o->getCaseY();
	if (globale::dangerObjet(x,y)==NULL){
		globale::dangerObjet(x,y,o);
		modif[x][y]=1;
		rect[x][y]=o->getRect();
		return true;
	};
	return false;
};

int liste::zero(int x,int y){
	if (globale::dangerObjet(x,y)!=NULL)
		return (globale::dangerObjet(x,y))->num();
	return 0;
};

bool liste::ajout(coordonnee &c,SDL_Surface* s,int n,joueur* j1,joueur* j2,joueur* j3,joueur* j4){
	int x=c.getXCase();
	int y=c.getYCase();
	if (globale::dangerObjet(x,y)!=NULL){
		return false;
	};
	globale::dangerObjet(x,y,new bombe(c,s,n,j1,j2,j3,j4));
	modif[x][y]=1;
	rect[x][y]=(globale::dangerObjet(x,y))->getRect();
	return true;
};

bool liste::ajout(int x,int y,coordonnee &c,SDL_Surface* ecran){
	if ((x<NB_CASE_X)&&(x>=0)&&(y<NB_CASE_Y)&&(y>=0))
		if (globale::dangerObjet(x,y)==NULL){
			globale::dangerObjet(x,y,new feu(c,ecran));
			modif[x][y]=1;
			rect[x][y]=(globale::dangerObjet(x,y))->getRect();
			return true;
		}else{
			modif[x][y]=2;
		};
	return false;
};


liste::~liste(){
	for (int i=0;i<NB_CASE_X;i++)
		for (int j=0;j<NB_CASE_X;j++){
			delete globale::dangerObjet(i,j);
			globale::danger(i,j)=0;
		};
};

void liste::ctr(contour *ctour){
	tour=ctour;
};

liste::liste(){
	tour=NULL;
	actux=0;
	actuy=0;
	for (int i=0;i<NB_CASE_X;i++)
		for (int j=0;j<NB_CASE_Y;j++){
			globale::dangerObjet(i,j,NULL);
			globale::danger(i,j)=0;
		};
};

bool liste::collision(int x,int y,bool b=false){
	if (globale::dangerObjet(x,y)!=NULL){
		if(globale::dangerObjet(x,y)->collision(x,y)){
			if (b) {
				if ((modif[x][y]!=5)&&(modif[x][y]!=2))
					modif[x][y]=3; //si c'est un test d'explosion
			};
			return true;
		};
	};
	return false;
};

//parcours les objets, ds qu'une collision est detecte, on colle la coordonnee  l'objet
int liste::colle(int y,joueur& j,int n){
	objet *tmp;
	int coll;
	int tours=0;
	int x=j.getXCase();
	int test=x;
	while (tours<3){
		if ((tours==1)&&(x<NB_CASE_X-1))
			test=x+1;
		if ((tours==2)&&(x>0))
			test=x-1;
		tmp=(globale::dangerObjet(test,y));
		if (tmp!=NULL){
			if (!tmp->exclu(n)){
				coll=tmp->collision(j);
				if(coll==1) {//collision...
					if(globale::danger(test,y)==BOMBE)
						return 2;
					return 1;
				};
				if(coll==2) {//collision avec du feu donc le joueur meurt
					j.tue();
					return 0;
				};
			}else{
				if(!tmp->dedans(j))
					tmp->stp_exclu(n);			
			};		
		};
		tours++;
	};
	return 0;
};


bool liste::danger_case(int x,int y){
	if (globale::dangerObjet(x,y)!=NULL){
		(globale::dangerObjet(x,y))->react();
		return true;
	};
	return false;
}
void liste::danger(int x,int y){
	int i=1;
	if ((y>=NB_CASE_Y)||(y<0))
		return;
	bool droite=true,gauche=true;
	while(droite||gauche){
		if (droite&&(x+i<NB_CASE_X)){
			if (globale::dangerObjet(x+i,y)!=NULL){
				(globale::dangerObjet(x+i,y))->react();
				droite=false;
			};
		}else
			droite=false;
		if (gauche&&(x-i>=0)){
			if (globale::dangerObjet(x-i,y)!=NULL){
				(globale::dangerObjet(x-i,y))->react();
				gauche=false;
			};
		}else
			gauche=false;
		i++;
	};
};


int liste::explose(SDL_Surface* ecran){
	int mod;
	objet *tmp=globale::dangerObjet(actux,actuy);
	mod=tmp->explose(ecran);
	if (mod==0){//l'objet n'est plus actif
		delete tmp;
		globale::dangerObjet(actux,actuy,NULL);
		afficheToutAutour(ecran);
	};
	if (mod==4){//l'objet est une case enflamme, reinitialiser son compteur
		((feu*)(globale::dangerObjet(actux,actuy)))->initdvpm();
		modif[actux][actuy]=1;
	};
	if (mod<-5){//l'objet est detruit mais un cadeau apparait
		coordonnee pos=tmp->position;
		afficheToutAutour(ecran);
		delete tmp;
		globale::dangerObjet(actux,actuy,new cadeau(pos,mod,ecran));
		modif[actux][actuy]=1;
		return 0;
	};

	return mod;
};


void liste::sup(){
	delete (globale::dangerObjet(actux,actuy));
	globale::dangerObjet(actux,actuy,NULL);
};


int *liste::amplitudeX(){
	if (globale::dangerObjet(actux,actuy)==NULL)
		return NULL;
	else 
		return (globale::dangerObjet(actux,actuy))->amplitudeX();
};
int *liste::amplitudeY(){
	if (globale::dangerObjet(actux,actuy)==NULL)
		return NULL;
	else 
		return (globale::dangerObjet(actux,actuy))->amplitudeY();
};
void liste::stp_direct(int x){
	if (globale::dangerObjet(actux,actuy)==NULL)
		return;
	else 
		(globale::dangerObjet(actux,actuy))->fin(x);
};

int liste::modifi(){
	if (globale::dangerObjet(actux,actuy)==NULL)
		return-1;
	return modif[actux][actuy];
};

int liste::pos(){
	if (globale::dangerObjet(actux,actuy)==NULL)
		return -1;
	return (globale::dangerObjet(actux,actuy))->possesseur;
};
int *liste::prep_exp(){
	if ((globale::dangerObjet(actux,actuy)!=NULL)&&
		((modif[actux][actuy]==2)||(modif[actux][actuy]==5))){
		if((globale::dangerObjet(actux,actuy))->num()==BOMBE){
			objet *tmp=(globale::dangerObjet(actux,actuy));
			globale::dangerObjet(actux,actuy,new feuPrincipal(env::supp,tmp));
		};
		return (globale::dangerObjet(actux,actuy))->creeFeu();
	};
	return NULL;
};

SDL_Rect liste::getRect(int y){
	return rect[actux][y];
}

void liste::afficheAutour(SDL_Surface *ecran,int x,int y,SDL_Rect rec){
	if ((x<NB_CASE_X-1)&&(y<NB_CASE_Y))
		if ((globale::dangerObjet(x+1,y)!=NULL)) 
			(globale::dangerObjet(x+1,y))->printBas(ecran,rec);
	if ((x>0)&&(y<(NB_CASE_Y-1)))
		if ((globale::dangerObjet(x-1,y+1)!=NULL)) 
			(globale::dangerObjet(x-1,y+1))->printBas(ecran,rec);
	if ((x<NB_CASE_X)&&(y<NB_CASE_Y-1))
		if ((globale::dangerObjet(x,y+1)!=NULL)) 
			(globale::dangerObjet(x,y+1))->printBas(ecran,rec);
	if ((x<NB_CASE_X-1)&&(y<NB_CASE_Y-1))
		if ((globale::dangerObjet(x+1,y+1)!=NULL)) 
			(globale::dangerObjet(x+1,y+1))->printBas(ecran,rec);
		if((x==NB_CASE_X-1)||(y==NB_CASE_Y-1)){
			tour->print(ecran,rec);
		};
};

void liste::afficheToutAutour(SDL_Surface *ecran){
	if (actux>0)
		if ((globale::dangerObjet(actux-1,actuy)!=NULL)) 
			(globale::dangerObjet(actux-1,actuy))->printBas(ecran,rect[actux][actuy]);
	if ((actux>0)&&(actuy>0))
		if ((globale::dangerObjet(actux-1,actuy-1)!=NULL)) 
			(globale::dangerObjet(actux-1,actuy-1))->printBas(ecran,rect[actux][actuy]);
	if (actuy>0)
		if ((globale::dangerObjet(actux,actuy-1)!=NULL)) 
			(globale::dangerObjet(actux,actuy-1))->printBas(ecran,rect[actux][actuy]);
};


void liste::afficheAutour(SDL_Surface *ecran){
	if (globale::dangerObjet(actux,actuy)!=NULL) 
		globale::dangerObjet(actux,actuy)->printBas(ecran,rect[actux][actuy]);
	if (actux<(NB_CASE_X-1))
		if ((globale::dangerObjet(actux+1,actuy)!=NULL)) 
			(globale::dangerObjet(actux+1,actuy))->printBas(ecran,rect[actux][actuy]);
	if ((actux>0)&&(actuy<(NB_CASE_Y-1)))
		if ((globale::dangerObjet(actux-1,actuy+1)!=NULL)) 
			(globale::dangerObjet(actux-1,actuy+1))->printBas(ecran,rect[actux][actuy]);
	if (actuy<(NB_CASE_Y-1))
		if ((globale::dangerObjet(actux,actuy+1)!=NULL)) 
			(globale::dangerObjet(actux,actuy+1))->printBas(ecran,rect[actux][actuy]);
	if ((actuy<(NB_CASE_Y-1))&&(actux<(NB_CASE_X-1)))
		if ((globale::dangerObjet(actux+1,actuy+1)!=NULL)) 
			(globale::dangerObjet(actux+1,actuy+1))->printBas(ecran,rect[actux][actuy]);
		if((actux==NB_CASE_X-1)||(actuy==NB_CASE_Y-1)){
			tour->print(ecran,rect[actux][actuy]);
		};
};


bool liste::suivant(){
	objet *tmp;
	actux++;
	if (actux>=NB_CASE_X){
		actux=0;
		actuy++;
	};
	if (actuy>=NB_CASE_Y)return false;
	do{
		tmp=(globale::dangerObjet(actux,actuy));
		if(tmp==NULL){
			actux++;
			if(actux>=NB_CASE_X){
				actux=0;
				actuy++;
			};
		};
	}while ((tmp==NULL)&&(actuy<NB_CASE_Y));
	return (tmp!=NULL);
};


void liste::affiche(SDL_Surface *ecran,chainage* chaine){
	chainage *tmp=chaine;
	int result;
	while (tmp!=NULL){
		result=tmp->valeur()->print(ecran);
		if (result==3)
			tmp->valeur()->obj->position.stop();
		tmp=tmp->suivant();
	};
};


int liste::affiche(SDL_Surface *ecran){
	if (actux>=NB_CASE_X){
		actux=0;
		actuy++;
	};
	if (actuy>=NB_CASE_Y)
		return 0;
	int result=-1;
	objet *tmp=globale::dangerObjet(actux,actuy);
	if ((tmp==NULL)||(modif[actux][actuy]==0)){//pas d'objet  afficher
		actux++;
		return affiche(ecran);
	};
	switch (modif[actux][actuy]) {
	case 1: //il faut afficher l'objet
		result=tmp->print(ecran);
		if (result==0){
			modif[actux][actuy]=0;//fin de l'affichage mais afficher les bord en plus...
		};
		if(result==2){//ie affichage du sprite fini
			delete tmp;
			globale::dangerObjet(actux,actuy,NULL);
		};
		if (result==3)
			modif[actux][actuy]=2;
		if (result!=-1)
			afficheAutour(ecran);
		break;
	case 2:	//une explosion a eu lieu
		modif[actux][actuy]=5;
		result=explose(ecran);
		if (result==-1){
			modif[actux][actuy]=0;//un objet indestructible explose
		}else{
			afficheAutour(ecran);
		};
		break;
	case 3://collision a detect une explosion avec l'objet
		modif[actux][actuy]=2;
		break;//explose, mais pas besoin d'afficher maintenant
	case 5://une explosion a lieu
		result=explose(ecran);
		if (result==-1){
			modif[actux][actuy]=0;//un objet indestructible explose
		}else if (result!=1)
			afficheAutour(ecran);
		break;
	};
	actux++;
	return affiche(ecran);
};


//***************************************************************************
//classe de gestion de l'environnement (stock des objets du decor)
//					class env
SDL_Surface *env::supp=NULL;
env::env(){
	fullscreen=false;
	util[0]=NULL;
	util[1]=NULL;
	util[2]=NULL;
	util[3]=NULL;
	int i;
	for (i=0;i<30;i++)key[i]=false;
	deb.x=deb.y=deb.w=deb.y=0;
	cont=NULL;
	pause=false;
	boom=NULL;
};


void env::cree1ligne(int dep,int min,int max,int trou){
	int rdm,rdm1;
	int nbtrou=0;
	coordonnee c;
	brique *b;
	if((dep%2)==0){
		for(int i=min;i<=max;i++){
			rdm=(int)((float)rand()*(max-min-trou)/(RAND_MAX+1));
			rdm1=(int)((float)rand()*(5)/(RAND_MAX+1));
			if ((rdm!=0)||(nbtrou>=trou)){
				c.init(dep*50,i*50);
				if(rdm1!=0){
					rdm1=(int)((float)rand()*(5)/(RAND_MAX+1));
					if(rdm1==1)
						b=new brique(c,-10,supp);
					else b=new brique(c,-11,supp);
				}else b=new brique(c,0,supp);
				this->ajout(b);
			}else
				nbtrou++;
		};
	}else{
		for(int i=(min/2);i<=(max/2);i++){
			rdm=(int)((float)rand()*(5)/(RAND_MAX+1));
			if ((rdm!=0)||(nbtrou>=trou)){
				c.init(dep*50,i*2*50);
				b=new brique(c,-10,supp);
				this->ajout(b);
			}else
				nbtrou++;
		};
	};
}

void env::cree2(SDL_Surface *fond,joueur**jou){
	for(int j=0;j<NB_CASE_X;j++){
		for(int k=0;k<NB_CASE_Y;k++){
			globale::danger(j,k)=CASE_VIDE;
		};
	};
	supp=SDL_DisplayFormat(IMG_Load("fond.tga"));
	cont=new contour(supp);
	Pobjet.ctr(cont);
	SDL_BlitSurface(supp,NULL,fond,NULL);
	this->ajout(jou[0]);
	this->ajout(jou[1]);
	this->ajout(jou[2]);
	this->ajout(jou[3]);
	coordonnee c;
	mur *m=NULL;
	bombe *bom=NULL;
	cadeau *cad=NULL;
	brique *br=NULL;
	c.init(1*50,1*50);m=new mur(c);this->ajout(m);
	c.init(2*50,3*50);br=new brique(c,-10,fond);this->ajout(br);
	c.init(4*50,4*50);br=new brique(c,-10,fond);this->ajout(br);
	c.init(5*50,5*50);br=new brique(c,-10,fond);this->ajout(br);
	c.init(6*50,6*50);br=new brique(c,-10,fond);this->ajout(br);
	c.init(7*50,7*50);br=new brique(c,-10,fond);this->ajout(br);
	c.init(8*50,8*50);br=new brique(c,-10,fond);this->ajout(br);
	c.init(9*50,9*50);br=new brique(c,-10,fond);this->ajout(br);
	c.init(1*50,9*50);cad=new cadeau(c,-10,fond);this->ajout(cad);
	c.init(4*50,8*50);cad=new cadeau(c,-10,fond);this->ajout(cad);
	c.init(5*50,7*50);cad=new cadeau(c,-10,fond);this->ajout(cad);
	c.init(1*50,6*50);cad=new cadeau(c,-10,fond);this->ajout(cad);
	c.init(7*50,5*50);cad=new cadeau(c,-10,fond);this->ajout(cad);
	c.init(8*50,4*50);cad=new cadeau(c,-10,fond);this->ajout(cad);
	c.init(9*50,3*50);cad=new cadeau(c,-10,fond);this->ajout(cad);
};

void env::cree1(SDL_Surface *fond,joueur**jou){
	int coefx=50+15;
	int coefy=50+25;
	mur *m;
	coordonnee c;
	supp=SDL_DisplayFormat(IMG_Load("fond.tga"));
	cont=new contour(supp);
	Pobjet.ctr(cont);
	SDL_BlitSurface(supp,NULL,fond,NULL);
	c.init(1*50,1*50);m=new mur(c);this->ajout(m);
	c.init(1*50,3*50);m=new mur(c);this->ajout(m);
	c.init(1*50,5*50);m=new mur(c);this->ajout(m);
	c.init(1*50,7*50);m=new mur(c);this->ajout(m);
	c.init(1*50,9*50);m=new mur(c);this->ajout(m);
	c.init(3*50,1*50);m=new mur(c);this->ajout(m);
	c.init(3*50,3*50);m=new mur(c);this->ajout(m);
	c.init(3*50,5*50);m=new mur(c);this->ajout(m);
	c.init(3*50,7*50);m=new mur(c);this->ajout(m);
	c.init(3*50,9*50);m=new mur(c);this->ajout(m);
	c.init(5*50,1*50);m=new mur(c);this->ajout(m);
	c.init(5*50,3*50);m=new mur(c);this->ajout(m);
	c.init(5*50,5*50);m=new mur(c);this->ajout(m);
	c.init(5*50,7*50);m=new mur(c);this->ajout(m);
	c.init(5*50,9*50);m=new mur(c);this->ajout(m);
	c.init(7*50,1*50);m=new mur(c);this->ajout(m);
	c.init(7*50,3*50);m=new mur(c);this->ajout(m);
	c.init(7*50,5*50);m=new mur(c);this->ajout(m);
	c.init(7*50,7*50);m=new mur(c);this->ajout(m);
	c.init(7*50,9*50);m=new mur(c);this->ajout(m);
	c.init(9*50,1*50);m=new mur(c);this->ajout(m);
	c.init(9*50,3*50);m=new mur(c);this->ajout(m);
	c.init(9*50,5*50);m=new mur(c);this->ajout(m);
	c.init(9*50,7*50);m=new mur(c);this->ajout(m);
	c.init(9*50,9*50);m=new mur(c);this->ajout(m);
	c.init(11*50,1*50);m=new mur(c);this->ajout(m);
	c.init(11*50,3*50);m=new mur(c);this->ajout(m);
	c.init(11*50,5*50);m=new mur(c);this->ajout(m);
	c.init(11*50,7*50);m=new mur(c);this->ajout(m);
	c.init(11*50,9*50);m=new mur(c);this->ajout(m);
	srand( (unsigned)time( NULL ) );
	rand();rand();
	cree1ligne(0,2,8,2);
	rand();rand();
	cree1ligne(1,2,8,5);
	cree1ligne(2,0,10,1);
	cree1ligne(3,0,10,3);
	rand();
	cree1ligne(4,0,10,2);
	cree1ligne(5,0,10,0);
	cree1ligne(6,0,10,5);
	rand();rand();
	cree1ligne(7,0,10,2);
	cree1ligne(8,0,10,1);
	rand();rand();
	cree1ligne(9,0,10,2);
	cree1ligne(10,0,10,1);
	cree1ligne(11,2,8,2);
	rand();rand();
	cree1ligne(12,2,8,1);
	this->ajout(jou[0]);
	this->ajout(jou[1]);
	this->ajout(jou[2]);
	this->ajout(jou[3]);
	music = FSOUND_Stream_Open("music_env1.mp3", /* nom du fichier */
                          FSOUND_LOOP_NORMAL,     
                          0,0);
	FSOUND_Stream_Play(0,music);
	FSOUND_SetVolume(0,100);
};

void env::ajout(joueur * j){
	if(util[0]==NULL)util[0]=j;else
		if(util[1]==NULL)util[1]=j;else
			if(util[2]==NULL) util[2]=j;else
				util[3]=j;
};

//attention, copie uniquement du pointeur, structure non duplique!!!
void env::ajout(objet * o){
	int pos=(o->position.getY()-10)/50;
	if ((pos<0)||(pos>NB_CASE_Y)) return;
	Pobjet.ajout(o);
};

bool env::bomb(int *pos,int n){
	if (pos==NULL)return false;
	coordonnee c;
	int x=pos[0];
	int y=pos[1];
	c.init(x*50,y*50);
	return Pobjet.ajout(c,supp,n,util[0],util[1],util[2],util[3]);
};

bool env::pe(){
	bool tmp=fullscreen;
	fullscreen=false;
	return tmp;
};

void env::actualise(SDL_Event& event,SDL_Surface *fond){
	if (DEBUG) debug::sync(fond);
	int i=0;
	touche(event,fond);
	if (pause) return;
	for(int j=0;j<NB_CASE_X;j++){
		for(int k=0;k<NB_CASE_Y;k++){
			if ((globale::danger(j,k)==0)||(globale::danger(j,k)==UN_JOUEUR)){
				globale::danger(j,k)=Pobjet.zero(j,k);
				if (globale::danger(j,k)==0){
					globale::danger(j,k)=CASE_VIDE;
					Pobjet.danger(j,k);
					i=1;
					bool haut=true,bas=true;
					while(haut||bas){
						if (bas&&(k+i<NB_CASE_Y)){
							bas=!Pobjet.danger_case(j,k+i);
						}else
							bas=false;
						if (haut&&(k-i>=0)){
							haut=!Pobjet.danger_case(j,k-i);
						}else
							haut=false;
						i++;
					};
				};
			};
			if (globale::danger(j,k)>0){
				globale::danger(j,k)--;//reduit le temps de l'explosion
			};
		};
	};
	i=0;
	if (util[0]!=NULL) util[0]->efface(fond);
	if (util[1]!=NULL) util[1]->efface(fond);
	if (util[2]!=NULL) util[2]->efface(fond);
	if (util[3]!=NULL) util[3]->efface(fond);
	stop_glisse();
	prep_explosion();
	Pobjet.init();
	Pobjet.affiche(fond,boom);
	Pobjet.affiche(fond);
	if (util[0]!=NULL) {
		colle(*(util[0]),0);
		util[0]->actualise();
		util[0]->initEfface(fond);
	};
	if (util[1]!=NULL){
		colle(*(util[1]),1);
		util[1]->actualise();
		util[1]->initEfface(fond);
	};
	if (util[2]!=NULL){
		colle(*(util[2]),2);
		util[2]->actualise();
		util[2]->initEfface(fond);
	};
	if (util[3]!=NULL){
		colle(*(util[3]),3);
		util[3]->actualise();
		util[3]->initEfface(fond);
	};
	if (DEBUG) debug::affiche(supp);
	print(fond);
};

void env::print(SDL_Surface *fond){
	int x,y,j;
	for (j=0;j<4;j++){
		if (util[j]!=NULL){
			x=util[j]->getXCase();
			y=util[j]->getYCase();
			util[j]->print(fond);
			Pobjet.afficheAutour(fond,x,y,util[j]->getRect());
			cont->print(fond,util[j]->getRect());
			if (DEBUG) debug::affichePers(util[j]);
		};
	};
};


void env::prep_explosion(){
	int* x,*y;
	coordonnee c;
	SDL_Rect rect={0,0,MUR_LARGEUR,MUR_HAUTEUR};
	Pobjet.init();
	do{
		if ((Pobjet.modifi()==2)||(Pobjet.modifi()==5)){
			x=Pobjet.amplitudeX();
			y=Pobjet.amplitudeY();
			if ((x!=NULL)&&(y!=NULL)){
				for (int bcl=1;bcl<=x[0];bcl++){
					if ((y[bcl]!=-1)&&(x[bcl]!=-1)){
						if(Pobjet.collision(x[bcl],y[bcl],true)){
							Pobjet.stp_direct(bcl-1);
						};
					}else{
						Pobjet.stp_direct(bcl-1);
					};
				};
			};
			affiche_feu();
		};
	}while(Pobjet.suivant());
};

void env::affiche_feu(){
	coordonnee c;
	//afficher le feu qui s'etend...
	int* cases=Pobjet.prep_exp();
	if (cases!=NULL){
			if(cases[0]!=-1){
				c.init(cases[0]*50,cases[1]*50);
				Pobjet.ajout(cases[0],cases[1],c,supp);
			};
			if(cases[2]!=-1){
				c.init(cases[2]*50,cases[3]*50);
				Pobjet.ajout(cases[2],cases[3],c,supp);
			};
			if(cases[4]!=-1){
				c.init(cases[4]*50,cases[5]*50);
				Pobjet.ajout(cases[4],cases[5],c,supp);
			};
			if(cases[6]!=-1){
				c.init(cases[6]*50,cases[7]*50);
				Pobjet.ajout(cases[6],cases[7],c,supp);
			};
		};
};

void env::touche(SDL_Event& event,SDL_Surface *fond){
	SDL_PollEvent(&event);
	int taille;
	int tmp=0;
	if(event.type==SDL_QUIT)
		exit(0);
	Uint8 *key=SDL_GetKeyState(&taille);
	if(key[SDLK_F1]){
		fullscreen=true;
		if (util[0]!=NULL) util[0]->full(fond);
		if (util[1]!=NULL) util[1]->full(fond);
		if (util[2]!=NULL) util[2]->full(fond);
		if (util[3]!=NULL) util[3]->full(fond);
	};
	if (key[SDLK_ESCAPE]){
		pause=!pause;
		SDL_ShowCursor(pause);
		SDL_Delay(500);
	};
	if(key[SDLK_p]){
		pause=!pause;
		SDL_ShowCursor(pause);
		SDL_Delay(25);
	};
	if (pause)return;
	if (util[3]!=NULL) util[3]->printposition();
	if (util[2]!=NULL) util[2]->printposition();
	if (util[1]!=NULL) util[1]->printposition();
	if (util[0]!=NULL) util[0]->printposition();
	if (util[0]!=NULL){
		if(util[0]->bouge(key)){//une bombe est pose
			if(bomb(util[0]->pose_bombe(),0))
				util[0]->bombPosee();//si on a pu poser de bombe, on le dit au joueur
		};
	};
	if (util[1]!=NULL){
		if(util[1]->bouge(key)){//une bombe est pose
			if(bomb(util[1]->pose_bombe(),1))
				util[1]->bombPosee();//si on a pu poser de bombe, on le dit au joueur
		};
	};
	if (util[2]!=NULL){
		if(util[2]->bouge(key)){//une bombe est pose
			if(bomb(util[2]->pose_bombe(),2))
				util[2]->bombPosee();//si on a pu poser de bombe, on le dit au joueur
		};
	};
	if (util[3]!=NULL){
		if(util[3]->bouge(key)){//une bombe est pose
			if(bomb(util[3]->pose_bombe(),3))
				util[3]->bombPosee();//si on a pu poser de bombe, on le dit au joueur
		};
	};
	if (util[0]!=NULL) util[0]->effposition();
	if (util[1]!=NULL) util[1]->effposition();
	if (util[2]!=NULL) util[2]->effposition();
	if (util[3]!=NULL) util[3]->effposition();
};

//parcours les bombes glissantes, ds qu'une collision est detecte, on stoppe la bombe
void env::stop_glisse(){
	chainage *tmp=boom;
	chainage *supp=NULL;
	int x;
	int y;
	int cpt=0;
	int direc;
	while (tmp!=NULL){
		x=tmp->valeur()->obj->getCaseX();
		y=tmp->valeur()->obj->getCaseY();
		direc=tmp->valeur()->obj->position.getVx();
		if (direc==0){
			direc=tmp->valeur()->obj->position.getVy();
			if(direc==0){//envoyer un signal  l'objet de dessous si il y a pour qu'il disparaisse
				if(!Pobjet.ajout(tmp->valeur()->obj))
					printf("bombe glissante non recupre\n");
				if(supp==NULL){
					supp=boom;
					boom=boom->suivant();
					delete supp;
					supp=NULL;
					tmp=boom;
				}else{
					supp->setSuivant(tmp->suivant());
					delete tmp;
					tmp=supp->suivant();
				};
			}else{
				if (direc>0){
					if (globale::dangerObjet(x,y+1)!=NULL){
						if(!Pobjet.ajout(tmp->valeur()->obj))
							printf("bombe glissante non recupre\n");
						if(supp==NULL){
							supp=boom;
							boom=boom->suivant();
							delete supp;
							supp=NULL;
							tmp=boom;
						}else{
							supp->setSuivant(tmp->suivant());
							delete tmp;
							tmp=supp->suivant();
						};
					}else{
						supp=tmp;
						tmp=tmp->suivant();
					}
				}else{
					if (globale::dangerObjet(x,y-1)!=NULL){
						if(!Pobjet.ajout(tmp->valeur()->obj))
							printf("bombe glissante non recupre\n");
						if(supp==NULL){
							supp=boom;
							boom=boom->suivant();
							delete supp;
							supp=NULL;
							tmp=boom;
						}else{
							supp->setSuivant(tmp->suivant());
							delete tmp;
							tmp=supp->suivant();
						};
					}else{
						supp=tmp;
						tmp=tmp->suivant();
					}
				}
			};
		}else{
			if (direc>0){
				if (globale::dangerObjet(x+1,y)!=NULL){
					if(!Pobjet.ajout(tmp->valeur()->obj))
						printf("bombe glissante non recupre\n");
					if(supp==NULL){
						supp=boom;
						boom=boom->suivant();
						delete supp;
						supp=NULL;
						tmp=boom;
					}else{
						supp->setSuivant(tmp->suivant());
						delete tmp;
						tmp=supp->suivant();
					};
				}else{
					supp=tmp;
					tmp=tmp->suivant();
				}
			}else{
				if (globale::dangerObjet(x-1,y)!=NULL){
					if(!Pobjet.ajout(tmp->valeur()->obj))
						printf("bombe glissante non recupre\n");
					if(supp==NULL){
						supp=boom;
						boom=boom->suivant();
						delete supp;
						supp=NULL;
						tmp=boom;
					}else{
						supp->setSuivant(tmp->suivant());
						delete tmp;
						tmp=supp->suivant();
					};
				}else{
					supp=tmp;
					tmp=tmp->suivant();
				};
			};
		};
	};
};

//parcours les objet, ds qu'une collision est detecte, on colle la coordonnee  l'objet
void env::colle(joueur& j,int n){//n est l'identifiant du joueur
	short dja=0;
	int i;
	int eu_collision=1;
	//commence un nouveau parcours
	while (eu_collision!=0){
		i=j.getYCase();
		eu_collision=0;
		if (i>0){
			eu_collision=Pobjet.colle(i-1,j,n);
			if(eu_collision==2){//collision avec une bombe!!!
				//le joueur peut il deplacer une bombe?
			};
		};
		if(eu_collision==0) eu_collision=Pobjet.colle(i,j,n);
		if ((i<NB_CASE_Y-1)&&(eu_collision==0))
			eu_collision=Pobjet.colle(i+1,j,n);
		if (eu_collision!=0){
			dja++;
			if (dja==2){
				j.position.reinit();
			};
			if(dja==3){
				j.position.reinit();
			};
			if (dja==6){
			printf("stop position !!!!!!!!!\n");
				j.stop();
				eu_collision=0;
			};
		}else{
		};
	};
};



SDL_Surface *debug::fond=NULL;
SDL_Surface *debug::point = IMG_Load("point.bmp");
SDL_Surface *debug::ligne = IMG_Load("ligne.bmp");
SDL_Surface *debug::ligne1 = IMG_Load("ligne1.bmp");
SDL_Surface *debug::m1 = IMG_Load("m1.bmp");
SDL_Surface *debug::m2 = IMG_Load("m2.bmp");
SDL_Surface *debug::m4 = IMG_Load("m4.bmp");
SDL_Surface *debug::plus = IMG_Load("plus.bmp");
SDL_Surface *debug::autre = IMG_Load("autre.bmp");
void debug::init(){
	SDL_SetColorKey(m1,SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
	SDL_SetColorKey(m2,SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
	SDL_SetColorKey(m4,SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
	SDL_SetColorKey(plus,SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
	SDL_SetColorKey(autre,SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
};

void debug::affichePers(joueur* j){
	SDL_Rect tmp={j->getX()+DEPLACEMENT_X,j->getY()+DEPLACEMENT_Y,0,0};
	SDL_BlitSurface(point,NULL,fond,&tmp);
};

void debug::afficheCarre(int x,int y,int x1,int y1){
	if(!DEBUGCASE)return;
	SDL_Rect tmp={x+DEPLACEMENT_X,y+DEPLACEMENT_Y,0,0};
	SDL_Rect coup={0,0,x1-x,y1-y};
	SDL_BlitSurface(ligne,&coup,fond,&tmp);
	SDL_BlitSurface(ligne1,&coup,fond,&tmp);
	tmp.x=x1+DEPLACEMENT_X;
	SDL_BlitSurface(ligne1,&coup,fond,&tmp);
	tmp.x=x+DEPLACEMENT_X;
	tmp.y=y1+DEPLACEMENT_Y;
	SDL_BlitSurface(ligne,&coup,fond,&tmp);
};

void debug::sync(SDL_Surface* surf){
	fond=surf;
};

void debug::affiche(SDL_Surface* eff){
	SDL_Rect tmp={0,0,0,0};
	SDL_Rect rec;
	rec.h=25;
	rec.w=25;
	for (int i=0;i<NB_CASE_X;i++){
		for (int j=0;j<NB_CASE_Y;j++){
			rec.x=i*50+DEPLACEMENT_X+10;
			rec.y=j*50+DEPLACEMENT_Y+5;
			if (globale::danger(i,j)==MUR_INDESTRUCTIBLE)
				SDL_BlitSurface(m1,NULL,fond,&rec);
			else if (globale::danger(i,j)==BOMBE)
				SDL_BlitSurface(m2,NULL,fond,&rec);
			else if (globale::danger(i,j)==MUR_DESTRUCTIBLE)
				SDL_BlitSurface(m4,NULL,fond,&rec);
			else if (globale::danger(i,j)>0)
				SDL_BlitSurface(plus,NULL,fond,&rec);
			else if ((globale::danger(i,j)==CASE_VIDE)||
				(globale::danger(i,j)==0))
				SDL_BlitSurface(eff,&rec,fond,&rec);
			else if (globale::danger(i,j)!=BONUS_PUISSANCE)
				SDL_BlitSurface(autre,NULL,fond,&rec);
		};
	};
//	for (int j=0;j<NB_CASE_Y;j++){
//		tmp.y=j*50+25;
//		SDL_BlitSurface(ligne,NULL,fond,&tmp);
//		tmp.y+=10;
//		SDL_BlitSurface(ligne,NULL,fond,&tmp);
//	};
};
