
#include "ia.h"

//********************************************************
//classe de controle du joueur par l'ordi
ia::ia(int nb,bool intel){
	coord=NULL;
	type=intel;
	direc=0;
	id=nb;
	x1=0;
	y1=0;
	ancienne_coordonnee=0;
};

void ia::synchro(joueur* j){
	joue=j;
	coord=&j->position;
	x1=coord->getXCase();
	y1=coord->getYCase();
};

void ia::enregistreposition(){
	int x=coord->getXCase();
	int y=coord->getYCase();
	ancienne_coordonnee=globale::danger(x,y);
};

void ia::printposition(){
	int x=coord->getXCase();
	int y=coord->getYCase();
	if(globale::danger(x,y)<=CASE_VIDE)
	{
		ancienne_coordonnee=globale::danger(x,y);
		globale::danger(x,y)=UN_JOUEUR;
	}else ancienne_coordonnee=99999;
};

void ia::directionJoueur(int x,int y){
	int i=0;
	int j=0;
	int xtmp;
	while ((j<NB_CASE_Y)&&(globale::danger(i,j)!=UN_JOUEUR)){
		i++;
		if (i>=NB_CASE_X){
			i=0;
			j++;
		};
	};
	if(x>i)
		xtmp=x-1;
	if(x<i)
		xtmp=x+1;
	if(x!=i){
		if(globale::danger(xtmp,y)==CASE_VIDE){
			x1=xtmp;y1=y;
			return;
		};
		if((y>0)&&(y>=i)&&(globale::danger(xtmp,y-1)==CASE_VIDE)){
			x1=xtmp;y1=y-1;
			return;
		};
		if((y<NB_CASE_Y-1)&&(y<=i)&&(globale::danger(xtmp,y+1)==CASE_VIDE)){
			x1=xtmp;y1=y+1;
			return;
		};
	};
	if((y>0)&&(y>=i)&&(globale::danger(x,y-1)==CASE_VIDE)){
		x1=x;y1=y-1;
		return;
	};
	if((y<NB_CASE_Y-1)&&(y<=i)&&(globale::danger(x,y+1)==CASE_VIDE)){
		x1=x;y1=y+1;
		return;
	};
};

void ia::effposition(){
	if(ancienne_coordonnee==99999)return;
	int x=coord->getXCase();
	int y=coord->getYCase();
	if (globale::danger(x,y)==UN_JOUEUR){
		globale::danger(x,y)=ancienne_coordonnee;
		return;
	};
};

int ia::deplace(Uint8 *touche){
	int sortie=0;
	if (type){
		effposition();
		sortie=deplaceIA();//-2 pour dire qu'il pose une bombe
		verifie();
		if (direc==0){
			centre();
			if (direc!=0){
				printf("erreur de centrage!!!!!!!! j:%i\n",id);
				return direc;
			};
		};
		if (id==JOUEUR)printf("direction finale : %i\t\t",direc);
		printposition();
		if (sortie==-2)
			return -2;
		joue->annim(direc);
		joue->position.deplace(direc);
		return direc;
	}else{
		direc=joue->clavier(touche);
		if(direc<0){
			joue->annim(-direc);
			joue->position.deplace(-direc);
			return -2;
		};
		int x=coord->getXCase();
		int y=coord->getYCase();
		joue->annim(direc);
		joue->position.deplace(direc);
		if((coord->getVx()==0)&&(coord->getVy()==0)){
			x1=x;
			y1=y;
			centre();
			joue->annim(direc);
			joue->position.deplace(direc);
		};
		return direc;
	};
};

void ia::centre(){
	direc=0;
	if((coord->getX()+TETE_LARGEUR/2-DEPLACEMENT_X)%50<20)
		direc=2;
	else{
		if((coord->getX()+TETE_LARGEUR/2-DEPLACEMENT_X)%50>30)
			direc=8;
	};
	if((coord->getY()+3*TETE_HAUTEUR/4-6-DEPLACEMENT_Y)%50<19)
		direc+=4;
	else{
		if((coord->getY()+3*TETE_HAUTEUR/4-6-DEPLACEMENT_Y)%50>23)
			direc+=1;
	};
};

void ia::verifie(){
	int x=coord->getXCase();
	int y=coord->getYCase();
	if (globale::danger(x,y)>CASE_VIDE)
		return;
	if ((globale::danger(x1,y1)>CASE_VIDE)&&
		(((globale::danger(x1,y1)+2*DVP<globale::danger(x,y))&&(globale::danger(x,y)>0))||
		((globale::danger(x1,y1)<2*DVP)&&(globale::danger(x1,y1)>0)))){
		x1=x;
		y1=y;
		centre();
		if (id==JOUEUR)printf("A ete verifi!!!!!!!!!!!!!! %i\n",direc);
	};
};

void ia::initIA(int x,int y){
	if ((globale::danger(x1,y1)<0)&&(globale::danger(x1,y1)>CASE_VIDE))
	{
		if ((x==x1+1)&&(y==y1)) x1=x;
		if ((x==x1-1)&&(y==y1)) x1=x;
		if ((y==y1+1)&&(x==x1)) y1=y;
		if ((y==y1-1)&&(x==x1)) y1=y;
	};
	if (((globale::danger(x,y)>0)&&(globale::danger(x,y)<2*DVP+15))||(globale::danger(x,y)==BOMBE)){
			fuite(x,y,6);
			if(x1tmp!=-1){
				x1=x1tmp;
				y1=y1tmp;
			};
	};
};

int ia::deplaceIA(){
	x1tmp=-1;
	y1tmp=-1;
	direc=0;
	int recherche=MUR_DESTRUCTIBLE;
	int x=coord->getXCase();
	int y=coord->getYCase();
	if (id==JOUEUR)printf("(%i , %i) ",x,y);
	initIA(x,y);
	if (direc!=0){
		if (id==JOUEUR)printf("fuit!!! : [%i,%i]->%i\n",x1,y1,direc);
		return direc;
	};
	if(caseProche(UN_JOUEUR))
		if(poseBombe(x,y,true)){
			if (id==JOUEUR)printf("pose une bombe pour un joueur\n");
			return -2;
		};
	if((x==x1)&&(y1==y)){
		centre();
		if(direc!=0){
			if (id==JOUEUR)printf("centre sur sa case  %i\n",direc);
			return direc;
		};
	}else{
		if(calcDirection(x,y,false)!=-1){
			if(x1tmp!=-1){
				x1=x1tmp;
				y1=y1tmp;
			};
			if (id==JOUEUR)printf(" passe par %i,%i -> %i\n",x1,y1,direc);
			return direc;
		};
	};
	if(cherche_cible(x,y,5,recherche)!=-1){
		if((x==x1)&&(y1==y)){
	//on est sur la case attendue donc on peut reflechir a quoi faire :
			if(poseBombe(x,y)){
				if (id==JOUEUR)printf(" pose une bombe \n");
				return -2;
			};
			//on ne peut pas poser de bombe
			if ((globale::danger(x,y)==BOMBE)||(globale::danger(x,y)>DVP)){
				fuite(x,y,6);
				if(x1tmp!=-1){
					x1=x1tmp;
					y1=y1tmp;
				};
				if (id==JOUEUR)printf("fuit : [%i , %i] ->  %i\n",x1,y1,direc);
				return direc;
			};
			if (id==JOUEUR)printf("attend un changement...\n");
		}else{
			if(calcDirection(x,y,false)!=-1){
				if(x1tmp!=-1){
					x1=x1tmp;
					y1=y1tmp;
				};
				if (id==JOUEUR)printf("direc exp : [%i , %i]%i\n",x1,y1,direc);
				return direc;
			};
			//on ne peut pas atteindre la case
			if (id==JOUEUR)printf("ne peut pas l'atteindre...\n");
			x1=x;
			y1=y;
			centre();
		};
	}else {
		if ((globale::danger(x,y)>0)||(globale::danger(x,y)==BOMBE)){
			fuite(x,y,6);
			if(x1tmp!=-1){
				x1=x1tmp;
				y1=y1tmp;
			};
			if (id==JOUEUR)printf("fuit case dangereuse [%i , %i] ->  %i\n",x1,y1,direc);
			return direc;
		};
		if (id==JOUEUR)printf("rien a faire aux alentours...\n");
		direc=0;
		directionJoueur(x,y);
		if(calcDirection(x,y,false)!=-1){
			if(x1tmp!=-1){
				x1=x1tmp;
				y1=y1tmp;
			};
			if (id==JOUEUR)printf(" passe par %i,%i -> %i\n",x1,y1,direc);
			return direc;
		};
	};
	return 0;
};

int ia::cherche_cible(int x,int y,int rest,int &typ){
	int tmpX;
	int tmpY;
	int prof=0;
	int suite=rest;
	int sortie=999;
	int tmp;
	int changement=0;
	if ((globale::danger(x,y)<2*DVP+16)&&(globale::danger(x,y)>=FEU_PRINCIPAL))
		return -1;
	if (globale::danger(x,y)>CASE_VIDE)//si on n'est pas sur une case bonus
		prof+=2;//la longueur du chemin s'accroit
	else prof++;
	//permet de privilegier les bonus
	if ((globale::danger(x,y)<=typ)&&(globale::danger(x,y)!=CASE_VIDE)){
		y1tmp=y;
		x1tmp=x;
		typ=globale::danger(x,y);
		if (id==JOUEUR)printf("[%i,%i]",x,y);
		if(globale::danger(x,y)<CASE_VIDE){
			return 0;//privilegie les bonus
		};
		if(typ==MUR_DESTRUCTIBLE)
			return 2;
		return 1;
	};
	if(rest<=0){
		return -1;
	};
	if((x+1)<NB_CASE_X){
		tmp=cherche_cible(x+1,y,suite-1,typ);
		if (tmp!=-1){
			if ((globale::danger(x+1,y)>CASE_VIDE)&&(globale::danger(x+1,y)<=0))
				if(globale::danger(x,y)>=0)
					tmp=9999;//case risquee
			if (sortie>tmp+prof){
				suite=tmp;
				if(suite>rest)suite=rest;
				sortie=tmp+prof;
				changement=1;
			};
		};
	};
	if((x-1)>=0){
		tmp=cherche_cible(x-1,y,suite-1,typ);
		if (tmp!=-1){
			if ((globale::danger(x-1,y)>CASE_VIDE)&&(globale::danger(x-1,y)<=0))
				if(globale::danger(x,y)>=0)tmp=9999;//case risquee
			if (sortie>tmp+prof){
				suite=tmp;
				if(suite>rest)suite=rest;
				sortie=tmp+prof;
				changement=2;
			};
		};
	};
	if((y+1)<NB_CASE_Y){
		tmp=cherche_cible(x,y+1,suite-1,typ);
		if (tmp!=-1){
			if ((globale::danger(x,y+1)>CASE_VIDE)&&(globale::danger(x,y+1)<=0))
				if(globale::danger(x,y)>=0)tmp=9999;//case risquee
			if (sortie>tmp+prof){
				suite=tmp;
				if(suite>rest)suite=rest;
				sortie=tmp+prof;
				changement=3;
			};
		};
	};
	if((y-1)>=0){
		tmp=cherche_cible(x,y-1,suite-1,typ);
		if (tmp!=-1){
			if ((globale::danger(x,y-1)>CASE_VIDE)&&(globale::danger(x,y-1)<=0))
				if(globale::danger(x,y)>=0)tmp=9999;//case risquee
			if (sortie>tmp+prof){
				suite=tmp;
				if(suite>rest)suite=rest;
				sortie=tmp+prof;
				changement=4;
			};
		};
	};
	switch (changement){
	case 0:return -1;
		break;
	case 1:
		//vers la droite
		if ((globale::danger(x+1,y)>CASE_VIDE)&&(globale::danger(x+1,y)<=0)){
			if(globale::danger(x,y)<=0){
				tmpX=x;//preserve la case d'un changement futur au cours de la recherche
				tmpY=y;
			};
		}else{
			tmpX=x+1;
			tmpY=y;
		}
		break;
	case 2:
		//vers la gauche
		if ((globale::danger(x-1,y)>CASE_VIDE)&&(globale::danger(x-1,y)<=0)){
			if(globale::danger(x,y)<=0){
				tmpX=x;//preserve la case d'un changement futur au cours de la recherche
				tmpY=y;
			};
		}else{
			tmpX=x-1;
			tmpY=y;
		}
		break;
	case 3:
		//vers le bas
		if ((globale::danger(x,y+1)>CASE_VIDE)&&(globale::danger(x,y+1)<=0)){
			if(globale::danger(x,y)<=0){
				tmpX=x;//preserve la case d'un changement futur au cours de la recherche
				tmpY=y;
			};
		}else{
			tmpX=x;
			tmpY=y+1;
		}
		break;
	case 4:
		//vers le haut
			if ((globale::danger(x,y-1)>CASE_VIDE)&&(globale::danger(x,y-1)<=0)){
				if(globale::danger(x,y)<=0){
					tmpX=x;//preserve la case d'un changement futur au cours de la recherche
					tmpY=y;
				};
			}else{
				tmpX=x;
				tmpY=y-1;
			}
		break;
	default:;
	};
	x1=tmpX;
	y1=tmpY;
	if(sortie<=0)return 0;
	return sortie;
};

//preced evite de revenir en arriere
int ia::fuite(int x,int y,int rest,int preced){
	x1tmp=-1;
	y1tmp=-1;
	int tmp;
	int pos=globale::danger(x,y);
	int fin=rest;
	int sortie=9999;
	int changement=0;
	if(globale::danger(x,y)<=CASE_VIDE){
		if (id==JOUEUR)printf("[%i,%i]",x,y);
		return 1;
	};
	if (rest<=0) return -1;
	if(((x+1)<NB_CASE_X)&&(preced!=2)&&
		((globale::danger(x+1,y)<=CASE_VIDE)||(globale::danger(x+1,y)>=2*DVP))){
		tmp=fuite(x+1,y,fin-1,1);
		if (tmp!=-1){
			if (sortie>tmp){
				if(globale::danger(x+1,y)>0)tmp++;//privilegie les chemins sr.
				sortie=tmp+1;
				changement=1;
				fin=tmp;
				if(fin>rest)fin=rest;
			};
		};
	};
	if(((x-1)>=0)&&(preced!=1)&&
		((globale::danger(x-1,y)<=CASE_VIDE)||(globale::danger(x-1,y)>=2*DVP))){
		tmp=fuite(x-1,y,fin-1,2);
		if (tmp!=-1){
			if (sortie>tmp){
				if(globale::danger(x-1,y)>0)tmp++;//privilegie les chemins sr.
				sortie=tmp+1;
				changement=2;
				fin=tmp;
				if(fin>rest)fin=rest;
			};
		};
	};
	if(((y+1)<NB_CASE_Y)&&(preced!=4)&&
		((globale::danger(x,y+1)<=CASE_VIDE)||(globale::danger(x,y+1)>=2*DVP))){
		tmp=fuite(x,y+1,fin-1,3);
		if (tmp!=-1){
			if (sortie>tmp){
				if(globale::danger(x,y+1)>0)tmp++;//privilegie les chemins sr.
				sortie=tmp+1;
				changement=3;
				fin=tmp;
				if(fin>rest)fin=rest;
			};
		};
	};
	if(((y-1)>=0)&&(preced!=3)&&
		((globale::danger(x,y-1)<=CASE_VIDE)||(globale::danger(x,y-1)>=2*DVP))){
		tmp=fuite(x,y-1,fin-1,4);
		if (tmp!=-1){
			if (sortie>tmp){
				if(globale::danger(x,y-1)>0)tmp++;//privilegie les chemins sr.
				sortie=tmp+1;
				changement=4;
				fin=tmp;
				if(fin>rest)fin=rest;
			};
		};
	};
	switch (changement){
	case 0:return -1;
		break;
	case 1:
		//vers la droite
		y1tmp=y;
		x1tmp=x+1;
		if((coord->getY()+3*TETE_HAUTEUR/4-6-DEPLACEMENT_Y)%50<4)
			direc=6;
		else{
			if((coord->getY()+3*TETE_HAUTEUR/4-6-DEPLACEMENT_Y)%50>33)
				direc=3;
			else direc=2;
		};
		break;
	case 2:
		//vers la gauche
		y1tmp=y;
		x1tmp=x-1;
		if((coord->getY()+3*TETE_HAUTEUR/4-6-DEPLACEMENT_Y)%50<4)
			direc=12;
		else{
			if((coord->getY()+3*TETE_HAUTEUR/4-6-DEPLACEMENT_Y)%50>33)
				direc=9;
			else direc=8;
		};
		break;
	case 3:
		//vers le bas
		y1tmp=y+1;
		x1tmp=x;
		if((coord->getX()+TETE_LARGEUR/2-DEPLACEMENT_X)%50<8)
			direc=6;
		else{
			if((coord->getX()+TETE_LARGEUR/2-DEPLACEMENT_X)%50>38)
				direc=12;
			else direc=4;
		};
		break;
	case 4:
		//vers le haut
		y1tmp=y-1;
		x1tmp=x;
		if((coord->getX()+TETE_LARGEUR/2-DEPLACEMENT_X)%50<8)
			direc=3;
		else{
			if((coord->getX()+TETE_LARGEUR/2-DEPLACEMENT_X)%50>38)
				direc=9;
			else 
				direc=1;
		};
		break;
	default:;
	};
	return sortie;
};

//preced evite de revenir en arriere
int ia::calcDirection(int x,int y,bool bomb,int continu,int preced){
	x1tmp=-1;
	y1tmp=-1;	
	int prof=0;
	if (globale::danger(x,y)>=CASE_VIDE)//si on n'est pas sur une case bonus
		prof++;//la longueur du chemin s'accroit
	//permet de privilegier les bonus

	int sortie=999;
	int tmp;
	int changement=0;
	//on pose la bombe...
	int pos[2]={x,y};
	if(bomb)return -2;

	//fin de recurcivit
	if ((x==x1)&&(y==y1))
		return 0;
	if ((globale::danger(x,y)<3*DVP)&&(globale::danger(x,y)>CASE_VIDE))
		return -1;
	if(continu==0) return -1;

	//debut de la fonction
	if(((x+1)<NB_CASE_X)&&(preced!=1)){
		tmp=calcDirection(x+1,y,false,continu-1,2);
		if (tmp!=-1){
			if (sortie>tmp+prof){
				changement=1;
				sortie=tmp+prof;
			};
		};
	};
	if(((x-1)>=0)&&(preced!=2)){
		tmp=calcDirection(x-1,y,false,continu-1,1);
		if (tmp!=-1){
			if (sortie>tmp+prof){
				changement=2;
				sortie=tmp+prof;
			};
		};
	};
	if(((y+1)<NB_CASE_Y)&&(preced!=3)){
		tmp=calcDirection(x,y+1,false,continu-1,4);
		if (tmp!=-1){
			if (sortie>tmp+prof){
				changement=3;
				sortie=tmp+prof;
			};
		};
	};
	if(((y-1)>=0)&&(preced!=4)){
		tmp=calcDirection(x,y-1,false,continu-1,3);
		if (tmp!=-1){
			if (sortie>tmp+prof){
				changement=4;
				sortie=tmp+prof;
			};
		};
	};
	switch (changement){
	case 0:return -1;
		break;
	case 1:
		//vers la droite
		if((coord->getY()+3*TETE_HAUTEUR/4-6-DEPLACEMENT_Y)%50<4)
			direc=6;
		else{
			if((coord->getY()+3*TETE_HAUTEUR/4-6-DEPLACEMENT_Y)%50>33)
				direc=3;
			else direc=2;
		};
		x1tmp=x+1;
		y1tmp=y;
		break;
	case 2:
		//vers la gauche
		if((coord->getY()+3*TETE_HAUTEUR/4-6-DEPLACEMENT_Y)%50<4)
			direc=12;
		else{
			if((coord->getY()+3*TETE_HAUTEUR/4-6-DEPLACEMENT_Y)%50>33)
				direc=9;
			else direc=8;
		};
		x1tmp=x-1;
		y1tmp=y;
		break;
	case 3:
		//vers le bas
		if((coord->getX()+TETE_LARGEUR/2-DEPLACEMENT_X)%50<8)
			direc=6;
		else{
			if((coord->getX()+TETE_LARGEUR/2-DEPLACEMENT_X)%50>38)
				direc=12;
			else direc=4;
		};
		x1tmp=x;
		y1tmp=y+1;
		break;
	case 4:
		//vers le haut
		if((coord->getX()+TETE_LARGEUR/2-DEPLACEMENT_X)%50<8)
			direc=3;
		else{
			if((coord->getX()+TETE_LARGEUR/2-DEPLACEMENT_X)%50>38)
				direc=9;
			else 
				direc=1;
		};
		x1tmp=x;
		y1tmp=y-1;
		break;
	default:;
	};
	return sortie;
};

bool ia::caseProche(int type,int profondeur){
	if((type==UN_JOUEUR)&&(ancienne_coordonnee==type))return true;
	bool droite=true,gauche=true,haut=true,bas=true;
	int min=MUR_DESTRUCTIBLE;
	if(min<=type)min=type+1;
	int x=coord->getXCase();
	int y=coord->getYCase();
	for (int i=1;i<=profondeur;i++){
		if(droite&&((x+i)<NB_CASE_X)&&
			((globale::danger(x+i,y)<min)||(globale::danger(x+i,y)>=0)||
				(globale::danger(x+i,y)==FEU))){
			if (globale::danger(x+i,y)==type)
				return true;
		}else droite=false;

		if(gauche&&((x-i)>=0)&&
			((globale::danger(x-i,y)<min)||(globale::danger(x-i,y)>=0)||
				(globale::danger(x-i,y)==FEU))){
			if (globale::danger(x-i,y)==type)
				return true;
		}else gauche=false;

		if(bas&&((y+i)<NB_CASE_Y)&&
			((globale::danger(x,y+i)<min)||(globale::danger(x,y+i)>=0)||
				(globale::danger(x,y+i)==FEU))){
			if (globale::danger(x,y+i)==type)
				return true;
		}else bas=false;

		if(haut&&((y-i)>=0)&&
			((globale::danger(x,y-i)<min)||(globale::danger(x,y-i)>=0)||
				(globale::danger(x,y-i)==FEU))){
			if (globale::danger(x,y-i)==type)
				return true;
		}else haut=false;
	};
	return false;
};


bool ia::poseBombe(int x,int y,bool suit_joueur){
	if((globale::danger(x,y)==BOMBE)||((globale::danger(x,y)<2*DVP+10)&&(globale::danger(x,y)>0)))
		return false;//on est sur la bombe qu'on vien de poser ou qui va exploser
	//test si ca vaut le coup de poser une bombe(pres d'une case destructible)
	bool fin=caseProche(BONUS_PUISSANCE,2);//MUR_DESTRUCTIBLE
	if(!fin) fin=!caseProche(MUR_DESTRUCTIBLE);
	if ((fin)&&(!suit_joueur)) return false;
	int prof=1;
	bool droite=true,gauche=true,haut=true,bas=true;
	while(prof<5)
	{
		//test a droite
		if(((x+prof)<NB_CASE_X)&&(droite)&&(
			((globale::danger(x+prof,y)>(prof+2)*DVP))||(globale::danger(x+prof,y)<=CASE_VIDE))){
			if ((y+1)<NB_CASE_Y)
				if((globale::danger(x+prof,y+1)<=CASE_VIDE))
				{
					return true;
				};
			if (y>0)
				if((globale::danger(x+prof,y-1)<=CASE_VIDE)){
					return true;
				};
		}else {
			droite=false;
		};
		//test a gauche
		if(((x-prof)>=0)&&gauche&&(
			((globale::danger(x-prof,y)>(prof+2)*DVP))||(globale::danger(x-prof,y)<=CASE_VIDE))){
			if ((y+1)<NB_CASE_Y)
				if((globale::danger(x-prof,y+1)<=CASE_VIDE))
				{
					return true;
				};
			if (y>0)
				if((globale::danger(x-prof,y-1)<=CASE_VIDE))
				{
					return true;
				};
		}else{
			gauche=false;
		};
		//test en haut
		if(((y-prof)>=0)&&haut&&(
			((globale::danger(x,y-prof)>(prof+2)*DVP))||(globale::danger(x,y-prof)<=CASE_VIDE))){
			if ((x+1)<NB_CASE_X)
				if((globale::danger(x+1,y-prof)<=CASE_VIDE))
				{
					return true;
				};
			if (x>0)
				if((globale::danger(x-1,y-prof)<=CASE_VIDE))
				{
					return true;
				};
		}else haut=false;
		//test en bas
		if(((y+prof)<NB_CASE_Y)&&bas&&(
			((globale::danger(x,y+prof)>(prof+2)*DVP))||(globale::danger(x,y+prof)<=CASE_VIDE))){
			if ((x+1)<NB_CASE_X)
				if((globale::danger(x+1,y+prof)<=CASE_VIDE))
				{
					return true;
				};
			if (x>0)
				if((globale::danger(x-1,y+prof)<=CASE_VIDE))
				{
					return true;
				};
		}else bas=false;
		prof++;
	};
	return false;
};

