
#include "joueur.h"

//***************************************************************************
//						class joueur
joueur::joueur(coordonnee& c,SDL_Surface* s,int nb,bool b):
position(c),deplacement(nb,b){
	deplacement.synchro(this);
	SDL_Surface * tmp= SDL_LoadBMP( "tete.bmp" );
	this->droite[0]= SDL_DisplayFormat(tmp);
	tmp= SDL_LoadBMP( "meur.bmp" );
	this->mort= SDL_DisplayFormat(tmp);
	tmp= SDL_LoadBMP( "tete1.bmp" );
	this->droite[1]= SDL_DisplayFormat(tmp);
	tmp= SDL_LoadBMP( "tete2.bmp" );
	this->droite[2]= SDL_DisplayFormat(tmp);
	tmp= SDL_LoadBMP( "tete3.bmp" );
	this->droite[3]= SDL_DisplayFormat(tmp);
	SDL_SetColorKey(mort,SDL_SRCCOLORKEY,0);
	SDL_SetColorKey(droite[0],SDL_SRCCOLORKEY,0);
	SDL_SetColorKey(droite[1],SDL_SRCCOLORKEY,0);
	SDL_SetColorKey(droite[2],SDL_SRCCOLORKEY,0);
	SDL_SetColorKey(droite[3],SDL_SRCCOLORKEY,0);
	tmp= SDL_LoadBMP( "tetebis.bmp" );
	this->gauche[0]= SDL_DisplayFormat(tmp);
	tmp= SDL_LoadBMP( "tetebis1.bmp" );
	this->gauche[1]= SDL_DisplayFormat(tmp);
	tmp= SDL_LoadBMP( "tetebis2.bmp" );
	this->gauche[2]= SDL_DisplayFormat(tmp);
	tmp= SDL_LoadBMP( "tetebis3.bmp" );
	this->gauche[3]= SDL_DisplayFormat(tmp);
	SDL_SetColorKey(gauche[0],SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
	SDL_SetColorKey(gauche[1],SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
	SDL_SetColorKey(gauche[2],SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
	SDL_SetColorKey(gauche[3],SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
	act.x =this->position.getX()+9;
	act.y=this->position.getY(); 
	act.w =TETE_LARGEUR;
	act.h =TETE_HAUTEUR;
	index_image=0;
	ancien[0]= SDL_CreateRGBSurface(SDL_HWSURFACE,TETE_LARGEUR,TETE_HAUTEUR, 32,
                                   0, 0, 0, 0);
	ancien[1]= SDL_CreateRGBSurface(SDL_HWSURFACE, TETE_LARGEUR,TETE_HAUTEUR, 32,
                                   0, 0, 0, 0);
	if ((ancien[0] == NULL)||(ancien[1] == NULL)) {
		fprintf(stderr, "CreateRGBSurface non abouti: %s\n", SDL_GetError());
		exit(1);
	};
	SDL_SetColorKey(ancien[0],SDL_SRCCOLORKEY,0);
	SDL_SetColorKey(ancien[1],SDL_SRCCOLORKEY,0);
	SDL_BlitSurface(s,&act,ancien[0],NULL);
	SDL_BlitSurface(s,&act,ancien[1],NULL);
	anc[0]=act; 
	anc[1]=act; 
	direction=0;
	bombes=1;
	actu=true;
	vivant=true;
	puissance=1;
};


int* joueur::pose_bombe(){
	if(bombes<=0)return NULL;
	int* sortie=new int[2];
	sortie[0]=this->getXCase();
	sortie[1]=this->getYCase();
	return sortie;
};

void joueur::tue(){
	position.stop();
	vivant=false;
};

void joueur::actualise(){
	position.actualise();
	act.x =this->position.getX()+9;
	act.y=this->position.getY();
	act.w=TETE_LARGEUR;
	act.h=TETE_HAUTEUR;
};

void joueur::bonux(int typ){
	switch (typ){
	case -10: 
		bombes++;
		break;
	case -11: 
		puissance++;
		break;
	};
};


void joueur::efface(SDL_Surface *Background){
	//on efface le joueur
	if (actu)
			SDL_BlitSurface(ancien[0],NULL,Background,&anc[0]);
	else 
			SDL_BlitSurface(ancien[1],NULL,Background,&anc[1]);
	actu=!actu;
};

void joueur::annim(int x){
	index_image++;
	if ((direction!=x)||(x==0)){
		direction=x;
		index_image=0;
	};
	if ((position.getVx()==0)&&(position.getVy()==0))
		index_image=0;
	if (index_image==16)index_image=0;
};

void joueur::full(SDL_Surface *Background){
	//on efface le joueur
	if (actu)
			SDL_BlitSurface(ancien[0],NULL,Background,&anc[0]);
	else 
			SDL_BlitSurface(ancien[1],NULL,Background,&anc[1]);
	actu=!actu;
};

void joueur::initEfface(SDL_Surface *Background){
	//si on est mort :
	if (!vivant){
		//Double buffer donc deux sauvegarde
		if (actu){
			//on enregistre l'ecran que l'on va effacer
			SDL_BlitSurface(Background,&act,ancien[0],NULL);
			anc[0]=act;
		}else{
			//on enregistre l'ecran que l'on va effacer
			SDL_BlitSurface(Background,&act,ancien[1],NULL);
			anc[1]=act;
		};
	}else{
		//Double buffer donc deux sauvegarde
		if (actu){
			//on enregistre l'ecran que l'on va effacer
			SDL_BlitSurface(Background,&act,ancien[0],NULL);
			anc[0]=act;
		}else{
			//on enregistre l'ecran que l'on va effacer
			SDL_BlitSurface(Background,&act,ancien[1],NULL);
			anc[1]=act;
		};
	};
};

void joueur::print(SDL_Surface *Background){
	//si on est mort :
	if (!vivant){
		SDL_BlitSurface(mort,NULL,Background,&act);
	}else{
		if((direction!=8)&&(direction!=9)&&(direction!=12))//puis on affiche
			SDL_BlitSurface(droite[index_image/4],NULL,Background,&act);
		if((direction==8)||(direction==9)||(direction==12))
			SDL_BlitSurface(gauche[index_image/4],NULL,Background,&act);
	};
};

bool joueur::bouge(Uint8 *key){
	if (!vivant)return false;
	int tmp=0;
	tmp=deplacement.deplace(key);
	if(tmp==-2)//une bombe est pose
		return true;
	return false;
};


//***************************************************************************
//						class merlin
int merlin::clavier(Uint8 *key){
	if (!vivant) return 0;
	int x=0;
	if (key[SDLK_w]) //haut
		if (key[SDLK_d])//droite
			x=3;
		else if (key[SDLK_a])//gauche
			x=9;
		else x=1;
	if (key[SDLK_s])//bas
		if (key[SDLK_d])//droite
				x=6;
		else if (key[SDLK_a])//gauche
			x=12;
		else x=4;
	if ((key[SDLK_d])&&(!key[SDLK_w])&&(!key[SDLK_s]))
		x=2;
	if ((key[SDLK_a])&&(!key[SDLK_w])&&(!key[SDLK_s]))
		x=8;
	if (key[SDLK_LCTRL])
		if (bombes>0){
			if(x==0)return -5;
			return -x;
		};
	return x;
};

//***************************************************************************
//						class trash
int trash::clavier(Uint8 *key){
	if (!vivant) return 0;
	int x=0;
	if (key[SDLK_UP]) 
		if (key[SDLK_RIGHT])
			x=3;
		else if (key[SDLK_LEFT])
			x=9;
		else x=1;
	if (key[SDLK_DOWN])
		if (key[SDLK_RIGHT])
				x=6;
		else if (key[SDLK_LEFT])
			x=12;
		else x=4;
	if ((key[SDLK_RIGHT])&&(!key[SDLK_UP])&&(!key[SDLK_DOWN]))
		x=2;
	if ((key[SDLK_LEFT])&&(!key[SDLK_UP])&&(!key[SDLK_DOWN]))
		x=8;
	if (key[SDLK_RETURN])
		if (bombes>0){
			if(x==0)return -5;
			return -x;
		};
	return x;
};
