
#include "objets.h"


//***************************************************************************
//classe de gestion des objets (murs,trou,guillotine...),virtuelle pure
//					class objet
objet::objet(objet& o){
	position=o.position;
	possesseur=o.possesseur;
	switsh=false;
};

objet::objet(coordonnee& c){
	position=c;
	possesseur=-1;
	switsh=false;
};

objet::objet(coordonnee& c,int pos){
	position=c;
	possesseur=pos;
	switsh=false;
};


bool objet::dedans(joueur &j){
	short jx=j.getX();//haut du carr de collision
	short jy=j.getY();
	short x1,x2,y1,y2;//coordonnes a eviter
	x1=this->getX();
	x2=x1+getTailleX();//+la largeur de collision du joueur
	y1=this->getY();
	y2=y1+getTailleY();//+la hauteur de collision du joueur
	if (DEBUG) debug::afficheCarre(x1,y1,x2,y2);
	return ((jx<x2)&&(jx>x1)&&(jy<y2)&&(jy>y1));
};

bool objet::collision(int x,int y){//appelle lors de la pose d'une bombe
	return ((x==getCaseX())&&(y==getCaseY()));
};

//Attention, collision dans cadeau a unifier!!!
int objet::collision(joueur &j){
	short jx=j.getX();//haut du carr de collision
	short jy=j.getY();
	short vx,vy;
	short x1,x2,y1,y2;//coordonnes a eviter
	x1=this->getX();
	x2=x1+getTailleX();//+la largeur de collision du joueur
	y1=this->getY();
	y2=y1+getTailleY();//+la hauteur de collision du joueur
		if (DEBUG) debug::afficheCarre(x1,y1,x2,y2);
	if ((jx<x2)&&(jx>x1)&&
		(jy<y2)&&(jy>y1)){
		vx=j.vecx();
		vy=j.vecy();
		jx-=vx;
		//que se passe t'il si on ne se deplace plus en X?
		if ((jx<x2)&&(jx>x1)&&
			(jy<y2)&&(jy>y1)){
			//collision de nouveau donc c'est vy est responsable
			jy-=vy;//on rammene y au point d'avant la collision
			if (vy>0){//direction vers le bas
				j.position.initY(y1-jy);
				return true;
			};
			if (vy<0){
				j.position.initY(y2-jy);
				return true;
			};
			//si on arrive jusqu'ici, c'est que x est mauvais
			//donc on continu les tests
		};
		jx+=vx;
		jy-=vy;
		//que se passe t'il si on ne se deplace plus en Y?
		if ((jx<x2)&&(jx>x1)&&
			(jy<y2)&&(jy>y1)){
			//collision de nouveau donc c'est vx qui est responsable
			jx-=vx;//on rammene x au point d'avant la collision
			if (vx>0){
				j.position.initX(x1-jx);
				return true;
			};
			if (vx<0){
				j.position.initX(x2-jx);
				return true;
			};
		};
		//si on est ici, c'est que x et y sont responsables de la collision
		//une fois sur deux, on privilegie x ou y
		if (vy>0){
			if (switsh)
				j.position.initY(y1-jy);
		}else{
			if (switsh)
				j.position.initY(y2-jy);
		};
		if (vx>0){
			if (!switsh)
				j.position.initX(x1-jx);
		}else{
			if (!switsh)
				j.position.initX(x2-jx);
		};
		switsh=!switsh;
		return true;
	};
	return false;
};



//***************************************************************************
//						class mur, derive de objet
//constructeur
SDL_Surface* mur::texture=SDL_LoadBMP( "mur1.bmp" );
mur::mur(coordonnee &c):objet(c){
	int x,y;
	SDL_SetColorKey(mur::texture,SDL_SRCCOLORKEY,0);
	act.x =this->position.getX()-12;
	act.y=this->position.getY()-15; 
	act.w = MUR_LARGEUR+20;
	act.h = MUR_HAUTEUR+19;
	gauche=act;
	gauche.w=20;
	haut=act;
	haut.h=19;
	dbuf=true;
	x=getCaseX();
	y=getCaseY();
	globale::danger(x,y)=MUR_INDESTRUCTIBLE;
};

mur::~mur(){
	int x=getCaseX();
	int y=getCaseY();
	globale::danger(x,y)=0;
};


int mur::print(SDL_Surface *Background){
	SDL_BlitSurface(texture,NULL,Background,&act); 
	if (dbuf) {
		dbuf=false;
		return -1;
	};
	return 0;
};


void mur::printBas(SDL_Surface* s,SDL_Rect &pos){
	SDL_Rect tmp=pos;
	SDL_Rect dest=act;
	tmp.x-=act.x;
	tmp.y-=act.y;
	dest.x=pos.x;
	dest.y=pos.y;
	SDL_BlitSurface(texture,&tmp,s,&dest); 
};



//***************************************************************************
//						class cadeau, derive de objet

cadeau::cadeau(coordonnee &c,int typ,SDL_Surface *Background):objet(c){
	int x,y;
	act.x =this->position.getX()+5;
	act.y=this->position.getY()+5; 
	act.w=MUR_LARGEUR;
	act.h=MUR_HAUTEUR;
	type=typ;
	eff= SDL_CreateRGBSurface(SDL_HWSURFACE, MUR_LARGEUR,MUR_HAUTEUR, 32,
                                   0, 0, 0, 0);
	if(eff == NULL) {
		fprintf(stderr, "CreateRGBSurface non abouti: %s\n", SDL_GetError());
		exit(1);
	};
	SDL_BlitSurface(Background,&act,eff,NULL);
	switch (type){
	case -10:
		texture= IMG_Load("bonux1.tga");
		SDL_SetColorKey(texture,SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
		break;
	case -11:
		texture= IMG_Load("bonux2.tga");
		SDL_SetColorKey(texture,SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
		break;
	};
	fin=0;
	x=getCaseX();
	y=getCaseY();
	globale::danger(x,y)=typ;
};

cadeau::~cadeau(){
	int x=getCaseX();
	int y=getCaseY();
	if (globale::danger(x,y)<=CASE_VIDE) globale::danger(x,y)=0;
};

int cadeau::collision(joueur &j){
	short jx=j.getX();//haut du carr de collision
	short jy=j.getY();
	short x1,x2,y1,y2;//coordonnes a eviter
	x1=this->getX();
	x2=x1+getTailleX();//+la largeur de collision du joueur
	y1=this->getY();
	y2=y1+getTailleY();//+la hauteur de collision du joueur
	if ((fin!=2)&&(fin!=-5)&&((jx)<x2)&&((jx)>x1)&&
		((jy)<y2)&&((jy)>y1)){
		if (fin==0) fin=1;
		else fin=2;
		j.bonux(type);
	};
	return false;
};


int cadeau::explose(SDL_Surface *fond){
	SDL_BlitSurface(eff,NULL,fond,&act);
	return 0;
};

int cadeau::print(SDL_Surface* fond){
	if (fin==2) 
		return 3;
	if ((fin==0)||(fin==100)){
		SDL_BlitSurface(texture,NULL,fond,&act);
		if (fin==100)fin=1;
		if (fin==0) fin=100;//pour le double buffer
	};
	return 1;
};
//***************************************************************************
//						class feu, derive de objet
//constructeur

SDL_Surface *feu::exp[2]={NULL,NULL};
void feu::init(){
	exp[0]=IMG_Load("exp.tga");
	exp[1]=IMG_Load("exp.tga");
	SDL_SetColorKey(exp[0],SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
	SDL_SetColorKey(exp[1],SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
};


feu::~feu(){
	SDL_FreeSurface(eff);
	int x=getCaseX();
	int y=getCaseY();
	globale::danger(x,y)=0;
};

feu::feu(coordonnee &c,SDL_Surface *effacer):objet(c){
	int x=getCaseX();
	int y=getCaseY();
	position.init(x*50+5,y*50+5);
	act.x = position.getX();
	act.y = position.getY(); 
	act.w = MUR_LARGEUR;
	act.h = MUR_HAUTEUR;
	globale::danger(x,y)=DVP+3;
	eff= SDL_CreateRGBSurface(SDL_HWSURFACE, act.w,act.h, 32,
                                   0, 0, 0, 0);
	if(eff == NULL) {
		fprintf(stderr, "CreateRGBSurface non abouti: %s\n", SDL_GetError());
		exit(1);
	};
	SDL_BlitSurface(effacer,&act,eff,NULL);
	dvpm=0;
	est_actif=true;
};

feu::feu(SDL_Surface *effacer,objet *o):objet(*o){
	int x=getCaseX();
	int y=getCaseY();
	position.init(x*50+5,y*50+5);
	act.x = position.getX();
	act.y = position.getY(); 
	act.w = MUR_LARGEUR;
	act.h = MUR_HAUTEUR;
	globale::danger(x,y)=DVP+3;
	eff= SDL_CreateRGBSurface(SDL_HWSURFACE, act.w,act.h, 32,
                                   0, 0, 0, 0);
	if(eff == NULL) {
		fprintf(stderr, "CreateRGBSurface non abouti: %s\n", SDL_GetError());
		exit(1);
	};
	SDL_BlitSurface(effacer,&act,eff,NULL);
	dvpm=0;
	est_actif=true;
};

bool feu::collision(int x,int y){
	if (!est_actif)return false;
	if ((x==getCaseX())&&(y==getCaseY()))
	{
		dvpm=0;
	};
	return false;
};

int feu::collision(joueur &j){
	if (!est_actif)return 0;
	if((getCaseX()==j.getXCase())&&(getCaseY()==j.getYCase())){
		return 2;
	};
	return 0;
};


int feu::explose(SDL_Surface * s){
	dvpm++;
	if (dvpm==1){
		SDL_BlitSurface(exp[0],NULL,s,&act); 
	};
	if (dvpm==DVP/2){
		SDL_BlitSurface(exp[1],NULL,s,&act); 
	};
	if(dvpm==DVP){
		est_actif=false;
		SDL_BlitSurface(eff,NULL,s,&act);
		return 3;
	};
	if(dvpm==DVP+1){
		SDL_BlitSurface(eff,NULL,s,&act);
		return 0;
	};
	return 3;
};

int feu::print(SDL_Surface *Background){
	return 3;
};


//***************************************************************************
//						class bombe, derive de objet
//constructeur
bombe_glisse::bombe_glisse(bombe* b){
	obj=b;
	efface= SDL_CreateRGBSurface(SDL_HWSURFACE,MUR_LARGEUR,MUR_HAUTEUR, 32,
			0, 0, 0, 0);
	if(efface == NULL) {
		fprintf(stderr, "CreateRGBSurface non abouti: %s\n", SDL_GetError());
		exit(1);
	};
};

int bombe_glisse::print(SDL_Surface *ecran){
	SDL_BlitSurface(efface,NULL,ecran,obj->pos());
	obj->position.actualise();
	SDL_BlitSurface(ecran,obj->pos(),efface,NULL);
	return obj->print(ecran);
};

//***************************************************************************
//						class bombe, derive de objet
//constructeur
FSOUND_SAMPLE *bombe::explosion=NULL;
SDL_Surface *bombe::attend[5]={NULL,NULL,NULL,NULL,NULL};
void bombe::init(){
	SDL_Surface *tmp=IMG_Load("bombe.bmp");
	attend[0] = SDL_DisplayFormat(tmp);
	tmp=IMG_Load("bombe1.bmp");
	attend[1] = SDL_DisplayFormat(tmp);
	tmp=IMG_Load("bombe2.bmp");
	attend[2] = SDL_DisplayFormat(tmp);
	tmp=IMG_Load("bombe3.bmp");
	attend[3] = SDL_DisplayFormat(tmp);
	attend[4] = IMG_Load("exp.tga");
	Uint32 noir=SDL_MapRGB(attend[0]->format,0,0,0);
	SDL_SetColorKey(attend[0],SDL_SRCCOLORKEY|SDL_RLEACCEL,noir);
	SDL_SetColorKey(attend[1],SDL_SRCCOLORKEY|SDL_RLEACCEL,noir);
	SDL_SetColorKey(attend[2],SDL_SRCCOLORKEY|SDL_RLEACCEL,noir);
	SDL_SetColorKey(attend[3],SDL_SRCCOLORKEY|SDL_RLEACCEL,noir);
	SDL_SetColorKey(attend[4],SDL_SRCCOLORKEY|SDL_RLEACCEL,noir);
	explosion=FSOUND_Sample_Load(FSOUND_FREE, "explose.wav",FSOUND_NORMAL,0,0);
	if (explosion==NULL){
		printf("chargement du son de la bombe...\n%d\n..",FSOUND_GetError());
		exit(5);
	};

};



int bombe::explose(SDL_Surface *fond){
	return 3;
};


bombe::~bombe(){
	SDL_FreeSurface(eff);
	int x=getCaseX();
	int y=getCaseY();
	globale::danger(x,y)=CASE_VIDE;
};

bombe::bombe(coordonnee &c,SDL_Surface *effacer,int poss,
			 joueur *j1=NULL,joueur *j2=NULL,joueur *j3=NULL,joueur *j4=NULL)
			 :objet(c,poss){
	int x,y;
	act.x = position.getX()+5;
	act.y = position.getY()+5; 
	act.w = MUR_LARGEUR;
	act.h = MUR_HAUTEUR;
	eff= SDL_CreateRGBSurface(SDL_HWSURFACE, act.w,act.h, 32,
                                   0, 0, 0, 0);
	if(eff == NULL) {
		fprintf(stderr, "CreateRGBSurface non abouti: %s\n", SDL_GetError());
		exit(1);
	};
	SDL_BlitSurface(effacer,&act,eff,NULL);
	dvpm=0;
	nb=0;
	excl[0]=((j1!=NULL)&&(dedans(*j1)));
	excl[1]=((j2!=NULL)&&(dedans(*j2)));
	excl[2]=((j3!=NULL)&&(dedans(*j3)));
	excl[3]=((j4!=NULL)&&(dedans(*j4)));
	if (poss==0)possede=j1;
	if (poss==1)possede=j2;
	if (poss==2)possede=j3;
	if (poss==3)possede=j4;
	taille=possede->getPuissance();;
	direction[0]=true;
	direction[1]=true;
	direction[2]=true;
	direction[3]=true;
	bool droite=true,gauche=true,haut=true,bas=true;
	bool droite1=true,gauche1=true,haut1=true,bas1=true;
	x=getCaseX();
	y=getCaseY();
	int anc=globale::danger(x,y);
	if (anc<=0)
		anc=7*DVP;
	globale::danger(x,y)=BOMBE;
	for (int i=1;i<=taille;i++){
		if(droite&&droite1&&((x+i)<NB_CASE_X)&&(globale::danger(x+i,y)==MUR_DESTRUCTIBLE))
			globale::danger(x+i,y)=MUR_INDESTRUCTIBLE;
		if(droite&&((x+i)<NB_CASE_X)&&
	((globale::danger(x+i,y)<MUR_DESTRUCTIBLE)||(globale::danger(x+i,y)>=0))){
			if ((globale::danger(x+i,y)<=BONUS_PUISSANCE)&&(globale::danger(x+i,y)!=UN_JOUEUR))
				droite1=false;
			if ((globale::danger(x+i,y)>anc)||(globale::danger(x+i,y)<=CASE_VIDE))
				globale::danger(x+i,y)=anc;
		}else 
			droite=false;

		if(gauche1&&gauche&&((x-i)>=0)&&(globale::danger(x-i,y)==MUR_DESTRUCTIBLE))
			globale::danger(x-i,y)=MUR_INDESTRUCTIBLE;
		if(gauche&&((x-i)>=0)&&
	((globale::danger(x-i,y)<MUR_DESTRUCTIBLE)||(globale::danger(x-i,y)>=0))){
			if ((globale::danger(x-i,y)<=BONUS_PUISSANCE)&&(globale::danger(x-i,y)!=UN_JOUEUR))
				gauche1=false;
			if ((globale::danger(x-i,y)>anc)||(globale::danger(x-i,y)<=CASE_VIDE))
				globale::danger(x-i,y)=anc;
		}else
			gauche=false;

		if(bas1&&bas&&((y+i)<NB_CASE_Y)&&(globale::danger(x,y+i)==MUR_DESTRUCTIBLE))
			globale::danger(x,y+i)=MUR_INDESTRUCTIBLE;
		if(bas&&((y+i)<NB_CASE_Y)&&
	((globale::danger(x,y+i)<MUR_DESTRUCTIBLE)||(globale::danger(x,y+i)>=0))){
			if ((globale::danger(x,y+i)<=BONUS_PUISSANCE)&&(globale::danger(x,y+i)!=UN_JOUEUR))
				bas1=false;
			if ((globale::danger(x,y+i)>anc)||(globale::danger(x,y+i)<=CASE_VIDE))
				globale::danger(x,y+i)=anc;
		}else
			bas=false;

		if(haut&&haut1&&((y-i)>=0)&&(globale::danger(x,y-i)==MUR_DESTRUCTIBLE))
			globale::danger(x,y-i)=MUR_INDESTRUCTIBLE;
		if(haut&&((y-i)>=0)&&
	((globale::danger(x,y-i)<MUR_DESTRUCTIBLE)||(globale::danger(x,y-i)>=0))){
			if ((globale::danger(x,y-i)<=BONUS_PUISSANCE)&&(globale::danger(x,y-i)!=UN_JOUEUR))
				haut1=false;
			if ((globale::danger(x,y-i)>anc)||(globale::danger(x,y-i)<=CASE_VIDE))
				globale::danger(x,y-i)=anc;
		}else
			haut=false;
	};
};

void bombe::react(){
	if (dvpm==0) 
		return;
	int anc=abs(6*DVP-abs(dvpm));
	bool droite=true,gauche=true,haut=true,bas=true;
	int x=getCaseX();
	int y=getCaseY();
	for (int i=1;i<=taille;i++){
		if(droite&&((x+i)<NB_CASE_X)&&
	((globale::danger(x+i,y)<MUR_DESTRUCTIBLE)||(globale::danger(x+i,y)>=0))){
			if ((globale::danger(x+i,y)>anc)||(globale::danger(x+i,y)<=CASE_VIDE))
				globale::danger(x+i,y)=anc;
		}else 
			droite=false;

		if(gauche&&((x-i)>=0)&&
	((globale::danger(x-i,y)<MUR_DESTRUCTIBLE)||(globale::danger(x-i,y)>=0))){
			if ((globale::danger(x-i,y)>anc)||(globale::danger(x-i,y)<=CASE_VIDE))
				globale::danger(x-i,y)=anc;
		}else
			gauche=false;

		if(bas&&((y+i)<NB_CASE_Y)&&
	((globale::danger(x,y+i)<MUR_DESTRUCTIBLE)||(globale::danger(x,y+i)>=0))){
			if ((globale::danger(x,y+i)>anc)||(globale::danger(x,y+i)<=CASE_VIDE))
				globale::danger(x,y+i)=anc;
		}else
			bas=false;

		if(haut&&((y-i)>=0)&&
	((globale::danger(x,y-i)<MUR_DESTRUCTIBLE)||(globale::danger(x,y-i)>=0))){
			if ((globale::danger(x,y-i)>anc)||(globale::danger(x,y-i)<=CASE_VIDE))
				globale::danger(x,y-i)=anc;
		}else
			haut=false;
	};
};

int *bombe::creeFeu(){
	if ((nb>=2*taille)||(nb<0)||(nb%2==0)) return NULL;
	int *sortie=new int[8];
	int x=getCaseX();
	int y=getCaseY();
	if(direction[1]&&((x+(nb+1)/2)<NB_CASE_X)&&
		((globale::danger(x+(nb+1)/2,y)==CASE_VIDE)||(globale::danger(x+(nb+1)/2,y)>=0))){
		sortie[0]=x+(nb+1)/2;
		sortie[1]=y;
	}else{
		sortie[0]=-1;
		sortie[1]=-1;
	};
	if(direction[2]&&((x-(nb+1)/2)>=0)&&
		((globale::danger(x-(nb+1)/2,y)==CASE_VIDE)||(globale::danger(x-(nb+1)/2,y)>=0))){
		sortie[2]=x-(nb+1)/2;
		sortie[3]=y;
	}else{
		sortie[2]=-1;
		sortie[3]=-1;
	};
	if(direction[3]&&((y+(nb+1)/2)<NB_CASE_Y)&&
		((globale::danger(x,y+(nb+1)/2)==CASE_VIDE)||(globale::danger(x,y+(nb+1)/2)>=0))){
		sortie[4]=x;
		sortie[5]=y+(nb+1)/2;
	}else{
		sortie[4]=-1;
		sortie[5]=-1;
	};
	if(direction[0]&&((y-(nb+1)/2)>=0)&&
		((globale::danger(x,y-(nb+1)/2)==CASE_VIDE)||(globale::danger(x,y-(nb+1)/2)>=0))){
		sortie[6]=x;
		sortie[7]=y-(nb+1)/2;
	}else{
		sortie[6]=-1;
		sortie[7]=-1;
	};
	return sortie;
};

int bombe::print(SDL_Surface *Background){
	dvpm++;
	if ((dvpm==1)||(dvpm==2)){
		SDL_BlitSurface(attend[0],NULL,Background,&act);
		return 10;
	}else
	if ((dvpm==2*DVP)||(dvpm==2*DVP+1)){
		SDL_BlitSurface(eff,NULL,Background,&act);
		SDL_BlitSurface(attend[1],NULL,Background,&act);
		return 10;
	}else{
		if ((dvpm==3*DVP)||(dvpm==3*DVP+1)){
			SDL_BlitSurface(eff,NULL,Background,&act);
			SDL_BlitSurface(attend[2],NULL,Background,&act);
			return 10;
		}else{
			if ((dvpm==4*DVP)||(dvpm==4*DVP+1)){
				SDL_BlitSurface(eff,NULL,Background,&act);
				SDL_BlitSurface(attend[3],NULL,Background,&act);
				return 10;
			}else{
				if (dvpm==5*DVP){
					dvpm++;
					SDL_BlitSurface(eff,NULL,Background,&act);
				};
				if (dvpm>=5*DVP+1){
					SDL_BlitSurface(eff,NULL,Background,&act);
					FSOUND_PlaySound(FSOUND_FREE,explosion);
					return 3;//explose
				};
			};
		};
	};
	return 1;//il reste des choses a afficher
};

void bombe::fin(int x){
	direction[x]=false;
};

int *bombe::amplitudeX(){
	nb++;
	int *sortie=new int[5];
	if ((nb>=2*taille)||(nb<0)||(nb%2==0)){
		return NULL;
	};
	sortie[0]=4;//nb de valeurs dans le tableau
	if (direction[0])//vers le haut autoris
		sortie[1]=getCaseX();
	else sortie[1]=-1;
	if (direction[1])//vers la droite autoris
		sortie[2]=getCaseX()+nb/2+1;
	else sortie[2]=-1;
	if (direction[2])//vers la gauche autoris
		sortie[3]=getCaseX()-(nb/2+1);
	else sortie[3]=-1;
	if (direction[3])//vers le bas autoris
		sortie[4]=getCaseX();
	else sortie[4]=-1;
	if (sortie[2]>=NB_CASE_X) sortie[2]=-1;
	if (sortie[3]<0) sortie[3]=-1;
	return sortie;
};


int *bombe::amplitudeY(){
	int *sortie=new int[5];
	if ((nb>=2*taille)||(nb<0)||(nb%2==0)){
		return NULL;
	};
	sortie[0]=4;//nb de valeurs dans le tableau
	if (direction[0])//vers le haut autoris
		sortie[1]=getCaseY()-(nb/2+1);
	else sortie[1]=-1;
	if (direction[1])//vers la droite autoris
		sortie[2]=getCaseY();
	else sortie[2]=-1;
	if (direction[2])//vers la gauche autoris
		sortie[3]=getCaseY();
	else sortie[3]=-1;
	if (direction[3])//vers le bas autoris
		sortie[4]=getCaseY()+(nb/2+1);
	else sortie[4]=-1;
	if (sortie[1]<0) sortie[1]=-1;
	if (sortie[4]>=NB_CASE_Y) sortie[4]=-1;
	return sortie;
};


//***************************************************************************
//						class brique, derive de objet
//constructeur
SDL_Surface *brique::texture=IMG_Load("brique1.bmp");
SDL_Surface *brique::expl=IMG_Load( "mur2.bmp" );
brique::brique(coordonnee &c,int cad,SDL_Surface *Background):objet(c){
	int x,y;
	act.x =this->position.getX();
	act.y=this->position.getY()-1; 
	act.w = MUR_LARGEUR+7;
	act.h = MUR_HAUTEUR+6;
	efface= SDL_CreateRGBSurface(SDL_HWSURFACE, act.w,act.h, 32,
                                   0, 0, 0, 0);
	if(efface == NULL) {
		fprintf(stderr, "CreateRGBSurface non abouti: %s\n", SDL_GetError());
		exit(1);
	};
	SDL_BlitSurface(Background,&act,efface,NULL);
	dvpm=0;
	cadeaux=cad;
	explo=false;
	x=getCaseX();
	y=getCaseY();
	globale::danger(x,y)=MUR_DESTRUCTIBLE;
};

brique::~brique(){
	int x=getCaseX();
	int y=getCaseY();
	globale::danger(x,y)=0;
};

void brique::init(){
	SDL_SetColorKey(expl,SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
	SDL_SetColorKey(texture,SDL_SRCCOLORKEY|SDL_RLEACCEL,0);
};

int brique::explose(SDL_Surface *Background){
	explo=true;
	if ((dvpm>=DVP)||(dvpm<0)){
		if (dvpm>=DVP){
			SDL_BlitSurface(efface,NULL,Background,&act);
			dvpm=-5;
			return 3;
		}else{
			SDL_BlitSurface(efface,NULL,Background,&act);
			SDL_FreeSurface(efface);
			efface=NULL;
			return cadeaux;//retourne l'objet bonus cach sous la brique
		};
	};
	if ((dvpm==0)||(dvpm==1)){
		SDL_BlitSurface(efface,NULL,Background,&act);
		SDL_BlitSurface(expl,NULL,Background,&act);
		dvpm++;
		return 5;//dire a l'environnement de le recouvrir
	};
	dvpm++;
	return 1;
};


int brique::print(SDL_Surface *Background){
	SDL_BlitSurface(texture,NULL,Background,&act);
	if (dvpm>90){
		if (dvpm<99){
			dvpm=200;
			return -1;
		}else{
			dvpm=0;
			return 0;
		};
	}else{
		dvpm=95;
		return -1;
	};
};

void brique::printBas(SDL_Surface* s,SDL_Rect &pos){
	SDL_Rect tmp=pos;
	SDL_Rect dest=act;
	tmp.x=pos.x-act.x;
	tmp.y=pos.y-act.y;
	dest.x=pos.x;
	dest.y=pos.y;
	if (explo)
		SDL_BlitSurface(expl,&tmp,s,&dest); 
	else
		SDL_BlitSurface(texture,&tmp,s,&dest); 
};



feuPrincipal::feuPrincipal(SDL_Surface *s,objet *b):feu(s,b){
	explosion=b;
	int x=getCaseX();
	int y=getCaseY();
	globale::danger(x,y)=FEU_PRINCIPAL;
};

feuPrincipal::~feuPrincipal(){
	delete explosion;
	int x=getCaseX();
	int y=getCaseY();
	globale::danger(x,y)=CASE_VIDE;
};

int feuPrincipal::explose(SDL_Surface * s){
	dvpm++;
	if (dvpm==1){
		((bombe*)explosion)->possede->bombplus();
		SDL_BlitSurface(exp[0],NULL,s,&act); 
	};
	if (dvpm==DVP/2){
		SDL_BlitSurface(exp[1],NULL,s,&act); 
	};
	if(dvpm==DVP){
		SDL_BlitSurface(eff,NULL,s,&act);
		est_actif=false;
		return 3;
	};
	if(dvpm==DVP+1){
		SDL_BlitSurface(eff,NULL,s,&act);
		return 3;
	};
	if(dvpm==DVP+15){
		return 0;
	};
	return 3;
};
