
#include "main.h"
#ifndef OBJET_ENV
#define OBJET_ENV 1

//***************************************************************************
//classe de gestion des objets (murs,trou,guillotine...)
class objet{
protected:
	bool switsh;//collisions a resoudre
public :
	virtual int num()=0;
	coordonnee position;//haut gauche de l'objet
	objet(objet&);
	objet(coordonnee&);
	objet(coordonnee&,int pos);
	virtual ~objet(){};
	//teste si une collision a lieu, repare dans ce cas
	virtual bool dedans(joueur&);//virtuelle
	virtual int collision(joueur&);//virtuelle
	virtual bool collision(int,int);
	//affiche l'objet
	virtual int print(SDL_Surface*)=0;//virtuelle pure
	virtual void printBas(SDL_Surface* s,SDL_Rect &pos){};
	virtual int explose(SDL_Surface*){return -1;};//cinematique de l'explosion
	virtual SDL_Rect* pos(){return NULL;};
	virtual bool exclu(int i){return false;};
	virtual void stp_exclu(int i){};
	virtual void fin(int){};
	virtual int *creeFeu(){return NULL;};
	virtual int* amplitudeX(){return NULL;};
	virtual int* amplitudeY(){return NULL;};
	virtual SDL_Rect getRect(){return *(new SDL_Rect());};
	int possesseur;
	virtual int getX(){return position.getX()-DEPLACEMENT_X-10;};
	virtual int getY(){return position.getY()-DEPLACEMENT_Y-15;};
	virtual int getTailleX(){return MUR_LARGEUR+16;};
	virtual int getTailleY(){return MUR_HAUTEUR+17;};
	virtual int getCaseX(){return (position.getX()-DEPLACEMENT_X)/50;};
	virtual int getCaseY(){return (position.getY()-DEPLACEMENT_Y)/50;};
	virtual void react(){};
};


class mur : public objet{
private :
	SDL_Rect act;
	SDL_Rect gauche;
	SDL_Rect haut;
	bool dbuf;
public:
	static SDL_Surface *texture;
	mur(coordonnee&);//constructeur
	~mur();
	int print(SDL_Surface*);
	void printBas(SDL_Surface*,SDL_Rect&);
	SDL_Rect getRect(){return act;};
	int num(){return MUR_INDESTRUCTIBLE;};
};

class brique : public objet{
private :
	int dvpm;
	static SDL_Surface *texture;
	static SDL_Surface *expl;
	SDL_Surface *efface;
	SDL_Rect act; 
	int cadeaux;
	bool explo;
public:
	brique(coordonnee&,int,SDL_Surface *);//constructeur
	~brique();
	static void init();
	int explose(SDL_Surface*);//cinematique de l'explosion
	int print(SDL_Surface*);
	void printBas(SDL_Surface*,SDL_Rect&);
	SDL_Rect getRect(){return act;};
	int num(){return MUR_DESTRUCTIBLE;};
};


class feu : public objet{
protected :
	static SDL_Surface *exp[];
	SDL_Surface *eff;
	SDL_Rect act;
	int dvpm;//developpement de l'esplosion
	bool est_actif;//si le feu est encore brulant
public:
	feu(coordonnee&,SDL_Surface *);
	feu(SDL_Surface *,objet*);
	~feu();
	virtual int explose(SDL_Surface*);//cinematique de explose
	static void init();
	int print(SDL_Surface*);
	SDL_Rect getRect(){return act;};
	void initdvpm(){dvpm=0;};
	int collision(joueur&);//virtuelle
	bool collision(int,int);
	int num(){return abs(DVP-dvpm);};
	virtual int* creeFeu(){return NULL;};
	int getX(){return position.getX()-DEPLACEMENT_X-5;};
	int getY(){return position.getY()-DEPLACEMENT_Y-10;};
	int getTailleX(){return MUR_LARGEUR+11;};
	int getTailleY(){return MUR_HAUTEUR+12;};
};

class bombe : public objet{
	friend class feuPrincipal;
	friend class bombe_glisse;
protected :
	static FSOUND_SAMPLE *explosion;
	int taille;
	int nb;//taille de l'explosion deja affich
	bool direction[4];
	SDL_Surface *eff;
	static SDL_Surface *attend[];
	bool excl[4];
	SDL_Rect act;
	int dvpm;//developpement de l'esplosion
	joueur *possede;
public:
	static void init();
	bombe(coordonnee&,SDL_Surface *,int,joueur *,joueur *,joueur *,joueur *);//constructeur
	~bombe();
	int explose(SDL_Surface*);//cinematique de explose
	int print(SDL_Surface*);
	SDL_Rect* pos(){return &act;};
	bool exclu(int j){
		return excl[j];
	};
	void stp_exclu(int j){
		excl[j]=false;
	};
	int tail_act(){return nb;};
	int* amplitudeX();
	int* amplitudeY();
	void fin(int);
	SDL_Rect getRect(){return act;};
	int *creeFeu();
	int num(){return BOMBE;};
	void react();
};

class bombe_glisse{
protected:
	SDL_Surface* efface;
public:
	bombe* obj;
	bombe_glisse(bombe*);
	int print(SDL_Surface*);
};

class cadeau : public objet{
private:
	int fin;//test si l'objet existe encore
	int type;
	SDL_Rect act; 
	SDL_Surface *eff;
	SDL_Surface* texture;
public:
	cadeau(coordonnee &,int,SDL_Surface*);
	~cadeau();
	int print(SDL_Surface*);
	int explose(SDL_Surface*);//cinematique de explose
	int collision(joueur &);//collision avec un joueur!!!
	SDL_Rect getRect(){return act;};
	int num(){return type;};
};


class feuPrincipal : public feu{
private:
	objet *explosion;
public:
	feuPrincipal(SDL_Surface *,objet *);
	~feuPrincipal();
	int* creeFeu(){if(est_actif)return ((bombe*)explosion)->creeFeu();return NULL;};
	SDL_Rect* pos(){return ((bombe*)explosion)->pos();};
	int tail_act(){return ((bombe*)explosion)->tail_act();};
	int* amplitudeX(){if(est_actif)return ((bombe*)explosion)->amplitudeX();return NULL;};
	int* amplitudeY(){if(est_actif)return ((bombe*)explosion)->amplitudeY();return NULL;};
	void fin(int f){((bombe*)explosion)->fin(f);};
	void react(){if(est_actif)((bombe*)explosion)->react();};
	int num(){return FEU_PRINCIPAL;};
	int explose(SDL_Surface*);
};


#endif
